/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.preferences;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.eclipse.help.internal.util.ProductPreferences;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class ProductPreferencesTest {
    private static final String[][] GET_ORDERED_LIST_DATA = new String[][]{{"a", "a", ""}, {"a", "a", "b,c,d", "e,f,g"}, {"a", "a", "a", "a"}, {"a,b,c", "a,b,c", "a", "b,c"}, {"a,b,c", "b,c,a", "b,c", "d,e,f", "g,h,i"}, {"1,2,3,4,5", "1,2,3,4,5", "2,3", "1,2", "4,5", "3,4"}, {"four,two,five,one,three", "one,two,three,four,five", "two,three", "one,two", "four,five", "three,four"}, {"seven,six,five,four,three,two,one", "one,two,three,four,five,six,seven", "one,two", "two,three,four", "one,two,six", "three,four,five", "five,six", "four,five", "six,seven"}, {"5,4,6,3,7,2,8,1,9", "9,8,7,6,5,4,3,2,1", "3,2,1", "9,8,7", "7,6,5", "5,4,3"}, {"5,4,6,3,7,2,8,1,9", "9,8,7,6,5,4,3,2,1", "9,7,5,3,1", "9,8,7,6,5,4,3,2,1"}, {"4,7,2,8,1,5,9,3,6", "1,2,3,4,5,6,7,8,9", "2,4,6,8", "1,3,5,7,9", "1,2", "3,4", "5,6", "7,8"}, {"1,2,3", "2,3,1", "2,3,1", "1,2,3", "1,3,2", "2,1,3", "2,3,1", "3,1,2", "3,2,1"}, {"3,2,1", "1,3,2", "1,3", "1,2"}, {"3,2,1", "1,2,3", "1,3", "1,2,3"}, {"2,1,3", "3,1,2", "3,1,2", "3,2,1", "3,2,1"}};
    private static final String[][] GET_PROPERTIES_FILE_DATA = new String[][]{{"propertiesSingle.txt", "myKey=myValue"}, {"propertiesMultiple.txt", "key1=value1", "key2=value2", "this.is.another/key=this.is.another.value"}};
    private static final String[][] GET_VALUE_DATA = new String[][]{{"keyDoesNotExist", "", "values1.txt", "values1.txt"}, {"key1", "value1", "values1.txt", "values1.txt"}, {"key2", "value2,value3", "values1.txt", "values1.txt", "values2.txt", "values3.txt"}, {"key3", "value3", "values1.txt", "values1.txt", "values2.txt", "values3.txt"}};
    private static final String[][] TOKENIZE_DATA = new String[][]{new String[1], {"Test", "Test"}, {"one, two, three", "one", "two", "three"}, {"repeat, repeat, repeat", "repeat", "repeat", "repeat"}, {"a,b,c", "a", "b", "c"}, {"semi;colon;separator", "semi", "colon", "separator"}, {"all\nkinds\rof\t whitespace", "all", "kinds", "of", "whitespace"}, {"many;,;,;,separators,;,;,;,test", "many", "separators", "test"}, {"mixed; space, and  separators", "mixed", "space", "and", "separators"}};

    @Test
    public void testGetOrderedList() {
        String[][] stringArray = GET_ORDERED_LIST_DATA;
        int n = GET_ORDERED_LIST_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            List items = ProductPreferences.tokenize((String)data[0]);
            List expectedOrder = ProductPreferences.tokenize((String)data[1]);
            List primaryOrdering = ProductPreferences.tokenize((String)data[2]);
            List secondaryOrderings = IntStream.range(0, data.length - 3).mapToObj(i -> ProductPreferences.tokenize((String)data[i + 3])).collect(Collectors.toList());
            List actualOrder = ProductPreferences.getOrderedList((List)items, (List)primaryOrdering, secondaryOrderings, null);
            Assertions.assertThat((List)actualOrder).containsExactlyElementsOf((Iterable)expectedOrder);
            ++n2;
        }
    }

    @Test
    public void testGetPropertiesFile() {
        String[][] stringArray = GET_PROPERTIES_FILE_DATA;
        int n = GET_PROPERTIES_FILE_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] data = stringArray[n2];
            String path = "data/help/preferences/" + data[0];
            Properties properties = ProductPreferences.loadPropertiesFile((String)FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), (String)path);
            ((MapAssert)Assertions.assertThat((Map)properties).as("result of loading a properties file", new Object[0])).isNotNull();
            Assertions.assertThat((Object[])data).hasSize(properties.size() + 1);
            int j = 1;
            while (j < data.length) {
                StringTokenizer tok = new StringTokenizer((String)data[j], "=");
                String key = tok.nextToken();
                String expectedValue = tok.nextToken();
                String actualValue = properties.getProperty(key);
                ((AbstractStringAssert)Assertions.assertThat((String)actualValue).as("one of the properties files' keys did not match the expected value: file=" + path + ", key=" + key, new Object[0])).isEqualTo(expectedValue);
                ++j;
            }
            ++n2;
        }
    }

    @Test
    public void testGetValue() {
        String[][] stringArray = GET_VALUE_DATA;
        int n = GET_VALUE_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            String key = data[0];
            HashSet allowableValues = new HashSet(ProductPreferences.tokenize((String)data[1]));
            Properties primary = ProductPreferences.loadPropertiesFile((String)FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), (String)("data/help/preferences/" + data[2]));
            Properties[] secondary = new Properties[data.length - 3];
            int j = 0;
            while (j < secondary.length) {
                secondary[j] = ProductPreferences.loadPropertiesFile((String)FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), (String)("data/help/preferences/" + data[j + 3]));
                ++j;
            }
            String value = ProductPreferences.getValue((String)key, (Properties)primary, (Properties[])secondary);
            if (allowableValues.isEmpty()) {
                ((AbstractStringAssert)Assertions.assertThat((String)value).as("value for key: " + key, new Object[0])).isNull();
            } else {
                Assertions.assertThat(allowableValues).contains((Object[])new String[]{value});
            }
            ++n2;
        }
    }

    @Test
    public void testTokenize() {
        String[][] stringArray = TOKENIZE_DATA;
        int n = TOKENIZE_DATA.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data = stringArray[n2];
            String input = data[0];
            List output = ProductPreferences.tokenize((String)input);
            ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)output).as("tokenized output for: " + input, new Object[0])).isNotNull()).as("check number of tokens", new Object[0])).hasSize(data.length - 1);
            int j = 0;
            while (j < output.size()) {
                ((AbstractStringAssert)Assertions.assertThat((String)((String)output.get(j))).as("one of the tokens did not match the expected result", new Object[0])).isEqualTo(data[j + 1]);
                ++j;
            }
            ++n2;
        }
    }
}

