/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.IOException;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ua.tests.help.remote.RemoteTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContentServletTest {
    private static final String UA_TESTS = "org.eclipse.ua.tests";
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testSimpleContent() throws Exception {
        String path = "/data/help/index/topic1.html";
        String remoteContent = RemoteTestUtils.getRemoteContent(UA_TESTS, "/data/help/index/topic1.html", "en");
        String localContent = RemoteTestUtils.getLocalContent(UA_TESTS, "/data/help/index/topic1.html");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Test
    public void testFilteredContent() throws Exception {
        String path = "/data/help/manual/filter.xhtml";
        String remoteContent = RemoteTestUtils.getRemoteContent(UA_TESTS, "/data/help/manual/filter.xhtml", "en");
        String localContent = RemoteTestUtils.getLocalContent(UA_TESTS, "/data/help/manual/filter.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Test
    public void testContentInEnLocale() throws Exception {
        String path = "/data/help/search/testnl1.xhtml";
        String remoteContent = RemoteTestUtils.getRemoteContent(UA_TESTS, "/data/help/search/testnl1.xhtml", "en");
        String localContent = RemoteTestUtils.getLocalContent(UA_TESTS, "/data/help/search/testnl1.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Test
    public void testContentInDeLocale() throws Exception {
        String path = "/data/help/search/testnl1.xhtml";
        String remoteContent = RemoteTestUtils.getRemoteContent(UA_TESTS, "/data/help/search/testnl1.xhtml", "de");
        String enLocalContent = RemoteTestUtils.getLocalContent(UA_TESTS, "/data/help/search/testnl1.xhtml");
        String deLocalContent = RemoteTestUtils.getLocalContent(UA_TESTS, "/nl/de/data/help/search/testnl1.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)deLocalContent);
        Assertions.assertFalse((boolean)remoteContent.equals(enLocalContent));
    }

    @Test
    public void testRemoteContentNotFound() throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            String string = RemoteTestUtils.getRemoteContent(UA_TESTS, "/no/such/path.html", "en");
        });
    }
}

