/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContextServletTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testRemoteContextFound() throws Exception {
        Object[] topics = this.getContextsFromServlet("org.eclipse.ua.tests.test_cheatsheets");
        Assertions.assertThat((Object[])topics).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcdefg", (Object)topics[0].getAttribute("label"));
    }

    @Test
    public void testRemoteContextFoundDe() throws Exception {
        Object[] topics = this.getContextsUsingLocale("org.eclipse.ua.tests.test_cheatsheets", "de");
        Assertions.assertThat((Object[])topics).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"German Context", (Object)topics[0].getAttribute("label"));
    }

    @Test
    public void testRemoteContextNotFound() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
            Element[] elementArray = this.getContextsFromServlet("org.eclipse.ua.tests.no_such_context");
        });
    }

    protected Element[] getContextsFromServlet(String phrase) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/context?id=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8));
        return this.makeServletCall(url);
    }

    protected Element[] getContextsUsingLocale(String phrase, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/context?id=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8) + "&lang=" + locale);
        return this.makeServletCall(url);
    }

    protected Element[] makeServletCall(URL url) throws IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"context", (Object)root.getNodeName());
            NodeList children = root.getChildNodes();
            ArrayList<Node> topics = new ArrayList<Node>();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node next = children.item(i);
                if ("topic".equals(next.getNodeName())) {
                    topics.add(next);
                }
                ++i;
            }
            return topics.toArray(new Element[topics.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

