/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.net.URL;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.eclipse.ua.tests.help.remote.RemoteTestUtils;
import org.eclipse.ua.tests.help.remote.TestServerManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class GetContentUsingRemoteHelp {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        RemotePreferenceStore.savePreferences();
        RemotePreferenceStore.setMockRemoteServer();
        RemotePreferenceStore.disableErrorPage();
        BaseHelpSystem.setMode((int)1);
        HelpPlugin.getTocManager().getTocs("en");
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testContentNotFound() {
        try {
            GetContentUsingRemoteHelp.getHelpContent("mock.toc", "/invalid/nosuchfile.html", "en");
            Assertions.fail((String)"No exception thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContentFound() throws Exception {
        String path = "/data/help/index/topic1.html";
        String remoteContent = GetContentUsingRemoteHelp.getHelpContent("mock.toc", "/data/help/index/topic1.html", "en");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent("mock.toc", "/data/help/index/topic1.html", "en", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    @Test
    public void testContentFoundDe() throws Exception {
        String path = "/data/help/index/topic2.html";
        String remoteContent = GetContentUsingRemoteHelp.getHelpContent("mock.toc", "/data/help/index/topic2.html", "de");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent("mock.toc", "/data/help/index/topic2.html", "de", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    @Test
    public void testLocalBeatsRemote() throws Exception {
        String path = "/doc/help_home.html";
        String plugin = "org.eclipse.help.base";
        String helpContent = GetContentUsingRemoteHelp.getHelpContent(plugin, "/doc/help_home.html", "en");
        String localContent = RemoteTestUtils.getLocalContent(plugin, "/doc/help_home.html");
        Assertions.assertEquals((Object)localContent, (Object)helpContent);
    }

    @Test
    public void testRemoteHelpPreferredPreference() throws Exception {
        RemotePreferenceStore.setMockRemotePriority();
        HelpPlugin.getTocManager().clearCache();
        HelpPlugin.getTocManager().getTocs("en");
        String path = "/doc/help_home.html";
        String plugin = "org.eclipse.help.base";
        String helpContent = GetContentUsingRemoteHelp.getHelpContent(plugin, "/doc/help_home.html", "en");
        int port = TestServerManager.getPort(0);
        String remoteContent = RemoteTestUtils.createMockContent(plugin, "/doc/help_home.html", "en", port);
        Assertions.assertEquals((Object)remoteContent, (Object)helpContent);
    }

    @Test
    public void testRemoteOrdering() throws Exception {
        RemotePreferenceStore.setTwoMockRemoteServers();
        RemotePreferenceStore.setMockRemotePriority();
        HelpPlugin.getTocManager().clearCache();
        HelpPlugin.getTocManager().getTocs("en");
        String path = "/doc/help_home.html";
        String plugin = "org.eclipse.help.base";
        String helpContent = GetContentUsingRemoteHelp.getHelpContent(plugin, "/doc/help_home.html", "en");
        int port0 = TestServerManager.getPort(0);
        String remoteContent0 = RemoteTestUtils.createMockContent(plugin, "/doc/help_home.html", "en", port0);
        int port1 = TestServerManager.getPort(1);
        String remoteContent1 = RemoteTestUtils.createMockContent(plugin, "/doc/help_home.html", "en", port1);
        Assertions.assertEquals((Object)remoteContent0, (Object)helpContent);
        Assertions.assertNotEquals((Object)remoteContent1, (Object)helpContent);
    }

    @Test
    public void testRemoteOrderingReversed() throws Exception {
        RemotePreferenceStore.setTwoMockRemoteServersReversePriority();
        RemotePreferenceStore.setMockRemotePriority();
        HelpPlugin.getTocManager().clearCache();
        HelpPlugin.getTocManager().getTocs("en");
        String path = "/doc/help_home.html";
        String plugin = "org.eclipse.help.base";
        String helpContent = GetContentUsingRemoteHelp.getHelpContent(plugin, "/doc/help_home.html", "en");
        int port0 = TestServerManager.getPort(0);
        String remoteContent0 = RemoteTestUtils.createMockContent(plugin, "/doc/help_home.html", "en", port0);
        int port1 = TestServerManager.getPort(1);
        String remoteContent1 = RemoteTestUtils.createMockContent(plugin, "/doc/help_home.html", "en", port1);
        Assertions.assertEquals((Object)remoteContent1, (Object)helpContent);
        Assertions.assertNotEquals((Object)remoteContent0, (Object)helpContent);
    }

    @Test
    public void testRemoteUsedIfLocalUnavaliable() throws Exception {
        RemotePreferenceStore.setMockRemoteServer();
        HelpPlugin.getTocManager().clearCache();
        HelpPlugin.getTocManager().getTocs("en");
        String path = "/data/help/nonlocal.html";
        String plugin = "org.eclipse.help.base";
        String remoteContent = GetContentUsingRemoteHelp.getHelpContent(plugin, "/data/help/nonlocal.html", "en");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent(plugin, "/data/help/nonlocal.html", "en", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    private static String getHelpContent(String plugin, String path, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/nftopic/" + plugin + path + "?lang=" + locale);
        return RemoteTestUtils.readFromURL(url);
    }
}

