/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext3;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GetContextUsingRemoteHelp {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
        this.mode = BaseHelpSystem.getMode();
        RemotePreferenceStore.setMockRemoteServer();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testContextDefaultLocale() throws Exception {
        IContext context = HelpPlugin.getContextManager().getContext("org.eclipse.ua.tests.test_one", "en");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)context);
        Object[] relatedTopics = context.getRelatedTopics();
        Assertions.assertThat((Object[])relatedTopics).hasSize(1);
        String topicLabel = relatedTopics[0].getLabel();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"context_one_en", (Object)topicLabel);
        String title = ((IContext3)context).getTitle();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"context_one_en", (Object)title);
        RemotePreferenceStore.disableRemoteHelp();
        context = HelpPlugin.getContextManager().getContext("org.eclipse.ua.tests.test_one", "en");
        org.junit.jupiter.api.Assertions.assertNull((Object)context);
    }

    @Test
    public void testLocalContextBeatsRemote() throws Exception {
        IContext context = HelpPlugin.getContextManager().getContext("org.eclipse.ua.tests.test_cheatsheets", "en");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)context);
        Object[] relatedTopics = context.getRelatedTopics();
        Assertions.assertThat((Object[])relatedTopics).hasSize(1);
        String topicLabel = relatedTopics[0].getLabel();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcdefg", (Object)topicLabel);
    }

    @Test
    public void testContextDeLocale() throws Exception {
        IContext context = HelpPlugin.getContextManager().getContext("org.eclipse.ua.tests.test_one", "de");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"context_one_de", (Object)((IContext3)context).getTitle());
    }

    @Test
    public void testContextNotFound() throws Exception {
        IContext context = HelpPlugin.getContextManager().getContext("org.eclipse.ua.tests.no_such_ctx", "en");
        org.junit.jupiter.api.Assertions.assertNull((Object)context);
    }
}

