/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IndexServletTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testIndexServletContainsSimpleWord() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "xyz");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithAccent() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "\u00e1mbito");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithGt() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "character >");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithLt() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "character <");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithAmp() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "character &");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithQuot() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "character \"");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testIndexServletContainsWordWithApostrophe() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "character '");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testDeWordNotInEnIndex() throws Exception {
        Node root = this.getIndexContributions("en");
        Object[] UARoot = this.findEntryInAllContributions(root, "munich");
        Assertions.assertThat((Object[])UARoot).isEmpty();
    }

    @Test
    public void testWordInDeIndex() throws Exception {
        Node root = this.getIndexContributions("de");
        Object[] UARoot = this.findEntryInAllContributions(root, "munich");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testWordNotInDeIndex() throws Exception {
        Node root = this.getIndexContributions("de");
        Object[] UARoot = this.findEntryInAllContributions(root, "xyz");
        Assertions.assertThat((Object[])UARoot).isEmpty();
    }

    private Element[] findEntryInAllContributions(Node parent, String keyword) {
        NodeList contributions = parent.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < contributions.getLength()) {
            Element nextElement;
            Node next = contributions.item(i);
            if (next instanceof Element && "indexContribution".equals((nextElement = (Element)next).getTagName())) {
                this.findEntryInIndexContribution(nextElement, keyword, results);
            }
            ++i;
        }
        return results.toArray(new Element[results.size()]);
    }

    private void findEntryInIndexContribution(Element parent, String keyword, List<Node> results) {
        NodeList indexes = parent.getChildNodes();
        int i = 0;
        while (i < indexes.getLength()) {
            Element nextElement;
            Node next = indexes.item(i);
            if (next instanceof Element && "index".equals((nextElement = (Element)next).getTagName())) {
                this.findMatchingChildEntry(nextElement, keyword, results);
            }
            ++i;
        }
    }

    private void findMatchingChildEntry(Element parent, String keyword, List<Node> results) {
        NodeList topLevelEntries = parent.getChildNodes();
        int i = 0;
        while (i < topLevelEntries.getLength()) {
            Element nextElement;
            Node next = topLevelEntries.item(i);
            if (next instanceof Element && "entry".equals((nextElement = (Element)next).getTagName()) && keyword.equals(nextElement.getAttribute("keyword"))) {
                results.add(next);
            }
            ++i;
        }
    }

    protected Node getIndexContributions(String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/index?lang=" + locale);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"indexContributions", (Object)root.getNodeName());
            return root;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

