/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoadIndexUsingRemoteHelp {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testIndexContribution() throws Exception {
        String locale = "en";
        HelpPlugin.getIndexManager().clearCache();
        IIndex index = HelpPlugin.getIndexManager().getIndex(locale);
        Assertions.assertThat((Object[])this.matchingEntries(index, "entry1_" + locale)).isEmpty();
        Assertions.assertThat((Object[])this.matchingEntries(index, "entry2_" + locale)).isEmpty();
        RemotePreferenceStore.setMockRemoteServer();
        HelpPlugin.getIndexManager().clearCache();
        index = HelpPlugin.getIndexManager().getIndex(locale);
        Assertions.assertThat((Object[])this.matchingEntries(index, "entry1_" + locale)).hasSize(1);
        Assertions.assertThat((Object[])this.matchingEntries(index, "entry2_" + locale)).hasSize(1);
    }

    @Test
    public void testIndexWithTwoRemoteServers() throws Exception {
        String locale = "en";
        HelpPlugin.getIndexManager().clearCache();
        IIndex index = HelpPlugin.getIndexManager().getIndex(locale);
        Object[] entry1 = this.matchingEntries(index, "entry1_" + locale);
        Assertions.assertThat((Object[])entry1).isEmpty();
        Object[] entry2 = this.matchingEntries(index, "entry2_" + locale);
        Assertions.assertThat((Object[])entry2).isEmpty();
        RemotePreferenceStore.setTwoMockRemoteServers();
        HelpPlugin.getIndexManager().clearCache();
        index = HelpPlugin.getIndexManager().getIndex(locale);
        entry1 = this.matchingEntries(index, "entry1_" + locale);
        entry2 = this.matchingEntries(index, "entry2_" + locale);
        Assertions.assertThat((Object[])entry1).hasSize(1);
        Assertions.assertThat((Object[])entry1[0].getTopics()).hasSize(1);
        Assertions.assertThat((Object[])entry2).hasSize(1);
        Assertions.assertThat((Object[])entry2[0].getTopics()).hasSize(2);
    }

    private IIndexEntry[] matchingEntries(IIndex index, String keyword) {
        IIndexEntry[] entries;
        ArrayList<IIndexEntry> matches = new ArrayList<IIndexEntry>();
        IIndexEntry[] iIndexEntryArray = entries = index.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexEntry entrie = iIndexEntryArray[n2];
            if (keyword.equals(entrie.getKeyword())) {
                matches.add(entrie);
            }
            ++n2;
        }
        return matches.toArray(new IIndexEntry[matches.size()]);
    }
}

