/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoadTocUsingRemoteHelp {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
        this.mode = BaseHelpSystem.getMode();
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testTocContribution() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        HelpPlugin.getTocManager().clearCache();
        Toc[] tocs = HelpPlugin.getTocManager().getTocs("en");
        int enTocs = this.matchingTocs(tocs, "Mock Toc en");
        Assertions.assertEquals((int)1, (int)enTocs);
        enTocs = this.matchingTocs(tocs, "Mock Toc 2 en");
        Assertions.assertEquals((int)1, (int)enTocs);
        int deTocs = this.matchingTocs(tocs, "Mock Toc de");
        Assertions.assertEquals((int)0, (int)deTocs);
        deTocs = this.matchingTocs(tocs, "Mock Toc 2 de");
        Assertions.assertEquals((int)0, (int)deTocs);
        RemotePreferenceStore.disableRemoteHelp();
    }

    @Test
    public void testTocContributionDe() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        HelpPlugin.getTocManager().clearCache();
        Toc[] tocs = HelpPlugin.getTocManager().getTocs("de");
        int enTocs = this.matchingTocs(tocs, "Mock Toc en");
        Assertions.assertEquals((int)0, (int)enTocs);
        enTocs = this.matchingTocs(tocs, "Mock Toc 2 en");
        Assertions.assertEquals((int)0, (int)enTocs);
        int deTocs = this.matchingTocs(tocs, "Mock Toc de");
        Assertions.assertEquals((int)1, (int)deTocs);
        deTocs = this.matchingTocs(tocs, "Mock Toc 2 de");
        Assertions.assertEquals((int)1, (int)deTocs);
        RemotePreferenceStore.disableRemoteHelp();
    }

    @Test
    public void testTocContributionFromTwoServers() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setTwoMockRemoteServers();
        HelpPlugin.getTocManager().clearCache();
        Toc[] tocs = HelpPlugin.getTocManager().getTocs("en");
        int enTocs = this.matchingTocs(tocs, "Mock Toc en");
        Assertions.assertEquals((int)1, (int)enTocs);
        int deTocs = this.matchingTocs(tocs, "Mock Toc de");
        Assertions.assertEquals((int)0, (int)deTocs);
        RemotePreferenceStore.disableRemoteHelp();
    }

    private int matchingTocs(Toc[] tocs, String label) {
        int result = 0;
        Toc[] tocArray = tocs;
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            if (label.equals(toc.getLabel())) {
                ++result;
            }
            ++n2;
        }
        return result;
    }
}

