/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.util.ParallelTestSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParallelSearchServletTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testNotFoundNonParallel() {
        ParallelTestSupport.testSingleCase(new SearchServletTester("duernfryehd", 0), 100);
    }

    @Test
    public void testFoundNonParallel() {
        ParallelTestSupport.testSingleCase(new SearchServletTester("jehcyqpfjs", 1), 100);
    }

    @Test
    public void testNotFoundInParallel() {
        ParallelTestSupport.testInParallel(new SearchServletTester[]{new SearchServletTester("duernfryehd", 0), new SearchServletTester("duernfryehd", 0)}, 100);
    }

    @Test
    public void testFoundInParallel() {
        ParallelTestSupport.testInParallel(new SearchServletTester[]{new SearchServletTester("jehcyqpfjs", 1), new SearchServletTester("jehcyqpfjs", 1)}, 100);
    }

    @Test
    public void testMixedParallelSearches() {
        ParallelTestSupport.testInParallel(new SearchServletTester[]{new SearchServletTester("jehcyqpfjs", 1), new SearchServletTester("duernfryehd", 0), new SearchServletTester("jehcyqpfjs", 1), new SearchServletTester("duernfryehd", 0)}, 100);
    }

    private Node[] getSearchHitsFromServlet(String phrase) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/search?phrase=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8));
        return this.makeServletCall(url);
    }

    private Node[] makeServletCall(URL url) throws IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            is.close();
            Assertions.assertEquals((Object)"searchHits", (Object)root.getNodeName());
            NodeList children = root.getChildNodes();
            ArrayList<Node> hits = new ArrayList<Node>();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node next = children.item(i);
                if ("hit".equals(next.getNodeName())) {
                    hits.add(next);
                }
                ++i;
            }
            return hits.toArray(new Node[hits.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class SearchServletTester
    implements ParallelTestSupport.ITestCase {
        private final String phrase;
        private final int expectedHits;

        public SearchServletTester(String phrase, int expectedHits) {
            this.phrase = phrase;
            this.expectedHits = expectedHits;
        }

        @Override
        public String runTest() throws Exception {
            Node[] hits = ParallelSearchServletTest.this.getSearchHitsFromServlet(this.phrase);
            if (hits.length != this.expectedHits) {
                return "Searching for " + this.phrase + " got " + hits.length + " hits, expected " + this.expectedHits;
            }
            return null;
        }
    }
}

