/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.eclipse.ua.tests.help.util.ParallelTestSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParallelSearchUsingRemote {
    private int mode;
    private final String[] searchWords = new String[]{"endfdsadsads", "dedfdsadsads", "jehcyqpfjs"};
    private final String[][] expectedResults = new String[][]{{"http://www.eclipse.org"}, new String[0], {"/org.eclipse.ua.tests/data/help/search/test1.xhtml"}};

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
        this.mode = BaseHelpSystem.getMode();
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testSearchOnOneThreadWithRemote() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        ParallelTestSupport.testSingleCase(new Searcher(), 100);
        RemotePreferenceStore.disableRemoteHelp();
    }

    @Test
    public void testSearchInParallelWithRemote() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        ParallelTestSupport.ITestCase[] testCases = new Searcher[3];
        int i = 0;
        while (i < 3) {
            testCases[i] = new Searcher();
            ++i;
        }
        ParallelTestSupport.testInParallel(testCases, 100);
        RemotePreferenceStore.disableRemoteHelp();
    }

    private class Searcher
    implements ParallelTestSupport.ITestCase {
        private int count = 0;

        private Searcher() {
        }

        @Override
        public String runTest() throws Exception {
            ++this.count;
            return SearchTestUtils.searchForExpectedResults(ParallelSearchUsingRemote.this.searchWords[this.count % 3], ParallelSearchUsingRemote.this.expectedResults[this.count % 3], "en");
        }
    }
}

