/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ua.tests.help.remote.RemotePreferenceTest;
import org.eclipse.ua.tests.help.remote.TestServerManager;

public class RemotePreferenceStore {
    private static String namePreference;
    private static String hostPreference;
    private static String pathPreference;
    private static String protocolPreference;
    private static String portPreference;
    private static String icEnabledPreference;
    private static String helpOn;
    private static String defaultPort;
    private static String remoteHelpPreferred;
    private static String pageNotFound;

    public static void savePreferences() throws Exception {
        namePreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpName", "", null);
        hostPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpHost", "", null);
        pathPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPath", "", null);
        protocolPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpProtocol", "", null);
        portPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPort", "", null);
        icEnabledPreference = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpICEnabled", "", null);
        defaultPort = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpUseDefaultPort", "", null);
        helpOn = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpOn", "", null);
        remoteHelpPreferred = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPreferred", "", null);
        pageNotFound = Platform.getPreferencesService().getString("org.eclipse.help.base", "page_not_found", "", null);
    }

    public static void restorePreferences() throws Exception {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put("remoteHelpName", namePreference);
        prefs.put("remoteHelpHost", hostPreference);
        prefs.put("remoteHelpPath", pathPreference);
        prefs.put("remoteHelpProtocol", protocolPreference);
        prefs.put("remoteHelpPort", portPreference);
        prefs.put("remoteHelpUseDefaultPort", defaultPort);
        prefs.put("remoteHelpOn", helpOn);
        prefs.put("remoteHelpICEnabled", icEnabledPreference);
        prefs.put("remoteHelpPreferred", remoteHelpPreferred);
        prefs.put("page_not_found", pageNotFound);
    }

    public static void setMockRemoteServer() throws Exception {
        TestServerManager.start("ua.test", 0);
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help");
        RemotePreferenceTest.setPreference("remoteHelpProtocol", "http");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "");
        RemotePreferenceTest.setPreference("remoteHelpPort", "" + TestServerManager.getPort(0));
        RemotePreferenceTest.setPreference("remoteHelpName", "uatest");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false");
    }

    public static void setTwoMockRemoteServers() throws Exception {
        TestServerManager.start("ua.test", 0);
        TestServerManager.start("ua.test2", 1);
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost,localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help,/help");
        RemotePreferenceTest.setPreference("remoteHelpProtocol", "http,http");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", ",");
        RemotePreferenceTest.setPreference("remoteHelpPort", TestServerManager.getPort(0) + "," + TestServerManager.getPort(1));
        RemotePreferenceTest.setPreference("remoteHelpName", "uatest,uatest2");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true,true");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false,false");
    }

    public static void setTwoMockRemoteServersReversePriority() throws Exception {
        TestServerManager.start("ua.test", 0);
        TestServerManager.start("ua.test2", 1);
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost,localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help,/help");
        RemotePreferenceTest.setPreference("remoteHelpProtocol", "http,http");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "true,true");
        RemotePreferenceTest.setPreference("remoteHelpPort", TestServerManager.getPort(1) + "," + TestServerManager.getPort(0));
        RemotePreferenceTest.setPreference("remoteHelpName", "uatest,uatest2");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true,true");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false,false");
    }

    public static void disableRemoteHelp() throws Exception {
        RemotePreferenceTest.setPreference("remoteHelpOn", "false");
    }

    public static void disableErrorPage() throws Exception {
        RemotePreferenceTest.setPreference("page_not_found", "");
    }

    public static void setMockLocalPriority() throws Exception {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpPreferred", "false");
    }

    public static void setMockRemotePriority() throws Exception {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpPreferred", "true");
    }
}

