/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemotePreferenceTest {
    public static void setPreference(String name, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put(name, value);
    }

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
    }

    private void setToDefault(String preference) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.remove(preference);
    }

    @Test
    public void testDefaults() {
        this.setToDefault("remoteHelpName");
        this.setToDefault("remoteHelpHost");
        this.setToDefault("remoteHelpPath");
        this.setToDefault("remoteHelpPort");
        this.setToDefault("remoteHelpICEnabled");
        this.setToDefault("remoteHelpOn");
        this.setToDefault("remoteHelpUseDefaultPort");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getEnabledEntries()).isEmpty();
    }

    @Test
    public void test33Defaults() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "false");
        RemotePreferenceTest.setPreference("remoteHelpHost", "");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "true");
        RemotePreferenceTest.setPreference("remoteHelpPort", "80");
        RemotePreferenceTest.setPreference("remoteHelpName", "");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getEnabledEntries()).isEmpty();
    }

    @Test
    public void test33Remote() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "false");
        RemotePreferenceTest.setPreference("remoteHelpPort", "8081");
        RemotePreferenceTest.setPreference("remoteHelpName", "");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(1);
    }

    @Test
    public void testZeroRemoteInfocenters() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "");
        RemotePreferenceTest.setPreference("remoteHelpPath", "");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "");
        RemotePreferenceTest.setPreference("remoteHelpPort", "");
        RemotePreferenceTest.setPreference("remoteHelpName", "");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getPortEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getEnabledEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getPathEntries()).isEmpty();
    }

    @Test
    public void testOneRemoteInfocenter() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "");
        RemotePreferenceTest.setPreference("remoteHelpPort", "8081");
        RemotePreferenceTest.setPreference("remoteHelpName", "local");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"localhost", (Object)handler.getHostEntries()[0]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8081", (Object)handler.getPortEntries()[0]);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)handler.getEnabledEntries()[0].toLowerCase());
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help", (Object)handler.getPathEntries()[0].toLowerCase());
    }

    @Test
    public void testTwoRemoteInfocenters() {
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost,www.eclipse.org");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help,/eclipse/help");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "");
        RemotePreferenceTest.setPreference("remoteHelpPort", "8081,8082");
        RemotePreferenceTest.setPreference("remoteHelpName", "local,remote");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true,false");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false,false");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"localhost", (Object)handler.getHostEntries()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"www.eclipse.org", (Object)handler.getHostEntries()[1]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8081", (Object)handler.getPortEntries()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8082", (Object)handler.getPortEntries()[1]);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)handler.getEnabledEntries()[0].toLowerCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"false", (Object)handler.getEnabledEntries()[1].toLowerCase());
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help", (Object)handler.getPathEntries()[0].toLowerCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/eclipse/help", (Object)handler.getPathEntries()[1].toLowerCase());
    }

    @Test
    public void testOnePathTwoOfEverythingElse() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "/help,/nhelp");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "true,false");
        RemotePreferenceTest.setPreference("remoteHelpPort", "8081,8082");
        RemotePreferenceTest.setPreference("remoteHelpName", "local,remote");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "true,false");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "false,true");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"localhost", (Object)handler.getHostEntries()[0]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8081", (Object)handler.getPortEntries()[0]);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)handler.getEnabledEntries()[0].toLowerCase());
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help", (Object)handler.getPathEntries()[0].toLowerCase());
    }

    @Test
    public void testPathOnly() {
        RemotePreferenceTest.setPreference("remoteHelpOn", "true");
        RemotePreferenceTest.setPreference("remoteHelpHost", "localhost");
        RemotePreferenceTest.setPreference("remoteHelpPath", "");
        RemotePreferenceTest.setPreference("remoteHelpUseDefaultPort", "");
        RemotePreferenceTest.setPreference("remoteHelpPort", "");
        RemotePreferenceTest.setPreference("remoteHelpName", "");
        RemotePreferenceTest.setPreference("remoteHelpICEnabled", "");
        RemotePreferenceTest.setPreference("remoteHelpICContributed", "");
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"localhost", (Object)handler.getHostEntries()[0]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(1);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(1);
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(1);
    }

    @Test
    public void testWriteNoRemote() {
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])new RemoteIC[0]);
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getPortEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getEnabledEntries()).isEmpty();
        Assertions.assertThat((Object[])handler.getPathEntries()).isEmpty();
    }

    @Test
    public void testWriteOneRemote() {
        RemoteIC[] ic = new RemoteIC[]{new RemoteIC(true, "name", "host", "/help", "http", "8080")};
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])ic);
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"host", (Object)handler.getHostEntries()[0]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8080", (Object)handler.getPortEntries()[0]);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)handler.getEnabledEntries()[0].toLowerCase());
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help", (Object)handler.getPathEntries()[0].toLowerCase());
    }

    @Test
    public void testWriteTwoRemote() {
        RemoteIC[] ic = new RemoteIC[]{new RemoteIC(true, "name", "host", "/help", "http", "8080"), new RemoteIC(false, "remote", "remotehost", "/help2", "http", "8081")};
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])ic);
        PreferenceFileHandler handler = new PreferenceFileHandler();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)handler.getTotalRemoteInfocenters());
        Assertions.assertThat((Object[])handler.getHostEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"host", (Object)handler.getHostEntries()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"remotehost", (Object)handler.getHostEntries()[1]);
        Assertions.assertThat((Object[])handler.getPortEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8080", (Object)handler.getPortEntries()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8081", (Object)handler.getPortEntries()[1]);
        Assertions.assertThat((Object[])handler.getEnabledEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)handler.getEnabledEntries()[0].toLowerCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"false", (Object)handler.getEnabledEntries()[1].toLowerCase());
        Assertions.assertThat((Object[])handler.getPathEntries()).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help", (Object)handler.getPathEntries()[0].toLowerCase());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/help2", (Object)handler.getPathEntries()[1].toLowerCase());
    }
}

