/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.server.WebappManager;
import org.osgi.framework.Bundle;

public class RemoteTestUtils {
    public static String createMockContent(String plugin, String path, String locale, int port) {
        String result = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"><HTML lang =\"" + locale + "\"><HEAD><TITLE> Content from: " + plugin + "</TITLE></HEAD><BODY><P>Path is: " + path + ",Port is: " + port + "</P></BODY></HTML>";
        return result;
    }

    public static String getRemoteContent(String plugin, String path, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/rtopic/" + plugin + path + "?lang=" + locale);
        return RemoteTestUtils.readFromURL(url);
    }

    public static String getLocalContent(String plugin, String path) throws IOException {
        Bundle bundle = Platform.getBundle((String)plugin);
        if (bundle == null) {
            throw new IOException("Invalid bundle " + plugin);
        }
        URL url = FileLocator.toFileURL((URL)new URL(bundle.getEntry("/"), path));
        return RemoteTestUtils.readFromURL(url);
    }

    /*
     * Loose catch block
     */
    public static String readFromURL(URL url) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            String string;
            InputStreamReader inputStreamReader;
            InputStream is;
            block17: {
                block16: {
                    int len;
                    is = url.openStream();
                    inputStreamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
                    StringBuilder buffer = new StringBuilder();
                    char[] cbuf = new char[256];
                    do {
                        if ((len = inputStreamReader.read(cbuf)) <= 0) continue;
                        buffer.append(cbuf, 0, len);
                    } while (len >= 0);
                    string = buffer.toString();
                    if (inputStreamReader == null) break block16;
                    inputStreamReader.close();
                }
                if (is == null) break block17;
                is.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

