/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.net.URL;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.ua.tests.help.remote.MockContentServlet;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SearchIndexCreation {
    private int mode;
    private AnalyzerDescriptor analyzerDesc;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        RemotePreferenceStore.savePreferences();
        RemotePreferenceStore.setMockRemoteServer();
        RemotePreferenceStore.disableErrorPage();
        BaseHelpSystem.setMode((int)1);
        HelpPlugin.getTocManager().getTocs("en");
        this.analyzerDesc = new AnalyzerDescriptor("en-us");
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testSearchIndexMakesNoRemoteCalls() throws Throwable {
        int initialCallCount = MockContentServlet.getCallcount();
        SearchIndexWithIndexingProgress index = new SearchIndexWithIndexingProgress("en-us", this.analyzerDesc, HelpPlugin.getTocManager());
        index.beginAddBatch(true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test7.html", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test8.htm", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test77.htm", false);
        index.endAddBatch(false, true);
        int finalCallCount = MockContentServlet.getCallcount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)(finalCallCount - initialCallCount)).as("Remote server called", new Object[0])).isZero();
    }

    @Test
    public void testSearchIndexMakesNoRemoteCalls2() throws Throwable {
        int initialCallCount = MockContentServlet.getCallcount();
        SearchIndexWithIndexingProgress index = new SearchIndexWithIndexingProgress("en-us", this.analyzerDesc, HelpPlugin.getTocManager());
        index.beginAddBatch(true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test7.html", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test8.htm", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test77.htm", false);
        index.endAddBatch(false, true);
        int finalCallCount = MockContentServlet.getCallcount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)(finalCallCount - initialCallCount)).as("Remote server called", new Object[0])).isZero();
    }

    @Test
    public void testSearchIndexMakesNoRemoteCallsRemotePriority() throws Throwable {
        RemotePreferenceStore.setMockRemotePriority();
        int initialCallCount = MockContentServlet.getCallcount();
        SearchIndexWithIndexingProgress index = new SearchIndexWithIndexingProgress("en-us", this.analyzerDesc, HelpPlugin.getTocManager());
        index.beginAddBatch(true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test7.html", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test8.htm", true);
        this.addHrefToIndex(index, "/org.eclipse.ua.tests/data/help/search/test77.htm", false);
        index.endAddBatch(false, true);
        int finalCallCount = MockContentServlet.getCallcount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)(finalCallCount - initialCallCount)).as("Remote server called", new Object[0])).isZero();
    }

    private void addHrefToIndex(SearchIndexWithIndexingProgress index, String doc, boolean exists) throws Throwable {
        URL url = SearchIndex.getIndexableURL((String)index.getLocale(), (String)doc);
        IStatus status = index.addDocument(url.getFile(), url);
        if (exists && !status.isOK()) {
            if (status.getException() != null) {
                throw status.getException();
            }
            org.junit.jupiter.api.Assertions.fail((String)(doc + " status = " + status.getMessage()));
        }
    }
}

