/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchServletTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testRemoteSearchNotFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("duernfryehd");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    @Test
    public void testRemoteSearchFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("jehcyqpfjs");
        Assertions.assertThat((Object[])hits).hasSize(1);
    }

    @Test
    public void testRemoteSearchOrFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("jehcyqpfjs OR duernfryehd");
        Assertions.assertThat((Object[])hits).hasSize(1);
    }

    @Test
    public void testRemoteSearchAndFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("jehcyqpfjs AND vkrhjewiwh");
        Assertions.assertThat((Object[])hits).hasSize(1);
    }

    @Test
    public void testRemoteSearchAndNotFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("jehcyqpfjs AND duernfryehd");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    @Test
    public void testRemoteSearchExactMatchFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("\"jehcyqpfjs vkrhjewiwh\"");
        Assertions.assertThat((Object[])hits).hasSize(1);
    }

    @Test
    public void testRemoteSearchExactMatchNotFound() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("\"vkrhjewiwh jehcyqpfjs\"");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    @Test
    public void testRemoteSearchWordNotInDefaultLocale() throws Exception {
        Object[] hits = this.getSearchHitsFromServlet("deuejwuid");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    @Test
    public void testRemoteSearchUsingDeLocale() throws Exception {
        Object[] hits = this.getSearchHitsUsingLocale("deuejwuid", "de");
        Assertions.assertThat((Object[])hits).hasSize(1);
    }

    @Test
    public void testRemoteSearchUsingEnLocale() throws Exception {
        Object[] hits = this.getSearchHitsUsingLocale("deuejwuid", "en");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    protected Node[] getSearchHitsFromServlet(String phrase) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/search?phrase=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8));
        return this.makeServletCall(url);
    }

    protected Node[] getSearchHitsUsingLocale(String phrase, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/search?phrase=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8) + "&lang=" + locale);
        return this.makeServletCall(url);
    }

    protected Node[] makeServletCall(URL url) throws IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            is.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"searchHits", (Object)root.getNodeName());
            NodeList children = root.getChildNodes();
            ArrayList<Node> hits = new ArrayList<Node>();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node next = children.item(i);
                if ("hit".equals(next.getNodeName())) {
                    hits.add(next);
                }
                ++i;
            }
            return hits.toArray(new Node[hits.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

