/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SearchUsingRemoteHelp {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        RemotePreferenceStore.savePreferences();
        this.mode = BaseHelpSystem.getMode();
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testSearchDefaultLocale() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        SearchTestUtils.searchOneLocale("endfdsadsads", new String[]{"http://www.eclipse.org"}, "en");
        RemotePreferenceStore.disableRemoteHelp();
        SearchTestUtils.searchOneLocale("endfdsadsads", new String[0], "en");
    }

    @Test
    public void testSearchDefaultLocaleTwoServers() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setTwoMockRemoteServers();
        SearchTestUtils.searchOneLocale("endfdsadsads", new String[]{"http://www.eclipse.org"}, "en");
        RemotePreferenceStore.disableRemoteHelp();
        SearchTestUtils.searchOneLocale("endfdsadsads", new String[0], "en");
    }

    @Test
    public void testSearchDeWordInDeLocale() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        SearchTestUtils.searchOneLocale("dedfdsadsads", new String[]{"http://www.eclipse.org"}, "de");
        RemotePreferenceStore.disableRemoteHelp();
        SearchTestUtils.searchOneLocale("dedfdsadsads", new String[0], "de");
    }

    @Test
    public void testSearchEnWordInDeLocale() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        SearchTestUtils.searchOneLocale("endfdsadsads", new String[0], "de");
        RemotePreferenceStore.disableRemoteHelp();
    }

    @Test
    public void testSearchDeWordInEnLocale() throws Exception {
        BaseHelpSystem.setMode((int)1);
        RemotePreferenceStore.setMockRemoteServer();
        SearchTestUtils.searchOneLocale("dedfdsadsads", new String[0], "en");
        RemotePreferenceStore.disableRemoteHelp();
    }
}

