/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.util.HashSet;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.remote.RemoteTocProvider;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFileProvider;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TocManagerTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        RemotePreferenceStore.savePreferences();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
        RemotePreferenceStore.restorePreferences();
    }

    @Test
    public void testDuplicatesOneRemote() throws Exception {
        RemotePreferenceStore.setMockRemoteServer();
        HelpPlugin.getTocManager().clearCache();
        boolean hasDuplicates = TocManagerTest.hasDuplicateContributions(HelpPlugin.getTocManager().getTocContributions("en"));
        Assertions.assertFalse((boolean)hasDuplicates);
    }

    @Test
    public void testDuplicatesTwoRemote() throws Exception {
        RemotePreferenceStore.setTwoMockRemoteServers();
        HelpPlugin.getTocManager().clearCache();
        boolean hasDuplicates = TocManagerTest.hasDuplicateContributions(HelpPlugin.getTocManager().getTocContributions("en"));
        Assertions.assertFalse((boolean)hasDuplicates);
    }

    @Test
    public void testLocalProviderPriority() throws Exception {
        AbstractTocProvider[] tocProviders;
        int localPriority = 0;
        int remotePriority = 0;
        RemotePreferenceStore.setMockRemoteServer();
        RemotePreferenceStore.setMockLocalPriority();
        HelpPlugin.getTocManager().clearCache();
        AbstractTocProvider[] abstractTocProviderArray = tocProviders = HelpPlugin.getTocManager().getTocProviders();
        int n = tocProviders.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTocProvider tocProvider = abstractTocProviderArray[n2];
            if (tocProvider instanceof TocFileProvider) {
                localPriority = tocProvider.getPriority();
            }
            if (tocProvider instanceof RemoteTocProvider) {
                remotePriority = tocProvider.getPriority();
            }
            ++n2;
        }
        Assertions.assertTrue((localPriority < remotePriority ? 1 : 0) != 0);
    }

    @Test
    public void testRemoteProviderPriority() throws Exception {
        AbstractTocProvider[] tocProviders;
        RemotePreferenceStore.setMockRemoteServer();
        RemotePreferenceStore.setMockRemotePriority();
        HelpPlugin.getTocManager().clearCache();
        int localPriority = 0;
        int remotePriority = 0;
        AbstractTocProvider[] abstractTocProviderArray = tocProviders = HelpPlugin.getTocManager().getTocProviders();
        int n = tocProviders.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTocProvider tocProvider = abstractTocProviderArray[n2];
            if (tocProvider instanceof TocFileProvider) {
                localPriority = tocProvider.getPriority();
            }
            if (tocProvider instanceof RemoteTocProvider) {
                remotePriority = tocProvider.getPriority();
            }
            ++n2;
        }
        Assertions.assertTrue((remotePriority < localPriority ? 1 : 0) != 0);
    }

    public static boolean hasDuplicateContributions(TocContribution[] tocContributions) {
        HashSet<String> contributionsFound = new HashSet<String>();
        TocContribution[] tocContributionArray = tocContributions;
        int n = tocContributions.length;
        int n2 = 0;
        while (n2 < n) {
            TocContribution tocContribution = tocContributionArray[n2];
            if (contributionsFound.contains(tocContribution.getId())) {
                return true;
            }
            contributionsFound.add(tocContribution.getId());
            ++n2;
        }
        return false;
    }
}

