/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.remote;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TocServletTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testTocServletContainsUAToc() throws Exception {
        Node root = this.getTocContributions("en");
        Object[] UARoot = this.findContributionById(root, "/org.eclipse.ua.tests/data/help/toc/root.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testTocServletContainsFilteredToc() throws Exception {
        Node root = this.getTocContributions("en");
        Object[] UARoot = this.findContributionById(root, "/org.eclipse.ua.tests/data/help/toc/filteredToc/toc.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testTocServletContainsUnlinkedToc() throws Exception {
        Node root = this.getTocContributions("en");
        Object[] UARoot = this.findContributionById(root, "/org.eclipse.ua.tests/data/help/toc/filteredToc/nonPrimaryToc.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testReadEnToc() throws Exception {
        Node root = this.getTocContributions("en");
        Object[] uaRoot = this.findContributionById(root, "/org.eclipse.ua.tests/data/help/search/toc.xml");
        Assertions.assertThat((Object[])uaRoot).hasSize(1);
        Object[] toc = this.findChildren((Node)uaRoot[0], "toc", "label", "search");
        Assertions.assertThat((Object[])toc).hasSize(1);
        Object[] topicSearch = this.findChildren((Node)toc[0], "topic", "label", "search");
        Assertions.assertThat((Object[])topicSearch).hasSize(1);
        Object[] topicEn = this.findChildren((Node)topicSearch[0], "topic", "label", "testen.html");
        Assertions.assertThat((Object[])topicEn).hasSize(1);
        Object[] topicDe = this.findChildren((Node)topicSearch[0], "topic", "label", "testde.html");
        Assertions.assertThat((Object[])topicDe).isEmpty();
    }

    @Test
    public void testReadDeToc() throws Exception {
        Node root = this.getTocContributions("de");
        Object[] uaRoot = this.findContributionById(root, "/org.eclipse.ua.tests/data/help/search/toc.xml");
        Assertions.assertThat((Object[])uaRoot).hasSize(1);
        Object[] toc = this.findChildren((Node)uaRoot[0], "toc", "label", "search");
        Assertions.assertThat((Object[])toc).hasSize(1);
        Object[] topicSearch = this.findChildren((Node)toc[0], "topic", "label", "search");
        Assertions.assertThat((Object[])topicSearch).hasSize(1);
        Object[] topicEn = this.findChildren((Node)topicSearch[0], "topic", "label", "testen.html");
        Assertions.assertThat((Object[])topicEn).isEmpty();
        Object[] topicDe = this.findChildren((Node)topicSearch[0], "topic", "label", "testde.html");
        Assertions.assertThat((Object[])topicDe).hasSize(1);
    }

    private Element[] findContributionById(Node root, String id) {
        return this.findChildren(root, "tocContribution", "id", id);
    }

    private Element[] findChildren(Node parent, String childKind, String attributeName, String attributeValue) {
        NodeList contributions = parent.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < contributions.getLength()) {
            Element nextElement;
            Node next = contributions.item(i);
            if (next instanceof Element && childKind.equals((nextElement = (Element)next).getTagName()) && attributeValue.equals(nextElement.getAttribute(attributeName))) {
                results.add(next);
            }
            ++i;
        }
        return results.toArray(new Element[results.size()]);
    }

    protected Node getTocContributions(String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/toc?lang=" + locale);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"tocContributions", (Object)root.getNodeName());
            return root;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

