/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.scope;

import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.ua.tests.help.other.UserIndexEntry;
import org.eclipse.ua.tests.help.other.UserToc;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.eclipse.ua.tests.help.scope.MockScope;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmptyLeafRemoval {
    @Test
    public void testEmptyLeafTopic() {
        UserTopic topic = new UserTopic("ab", null, true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', false)));
    }

    @Test
    public void testEmptyParentOfEmptyLeafTopic() {
        UserTopic topic = new UserTopic("ab", null, true);
        UserTopic child = new UserTopic("ac", null, true);
        topic.addTopic(child);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', false)));
    }

    @Test
    public void testEmptyParentOfNonEmptyLeafTopic() {
        UserTopic topic = new UserTopic("ab", null, true);
        UserTopic child = new UserTopic("ac", "http://www.eclipse.org", true);
        topic.addTopic(child);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', false)));
    }

    @Test
    public void testEmptyParentOfNonEmptyLeafTopicHierarchical() {
        UserTopic topic = new UserTopic("ab", null, true);
        UserTopic child = new UserTopic("ac", "http://www.eclipse.org", true);
        topic.addTopic(child);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', true)));
    }

    @Test
    public void testEmptyGrandParentWithOutOfScopeChildTopicHierarchical() {
        UserTopic topic = new UserTopic("ab", null, true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        UserTopic grandChild = new UserTopic("ac", "http://www.eclipse.org", true);
        topic.addTopic(child);
        child.addTopic(grandChild);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', true)));
    }

    @Test
    public void testEmptyGrandparentOfNonEmptyLeafTopicHierarchical() {
        UserTopic topic = new UserTopic("ab", null, true);
        UserTopic child = new UserTopic("ac", null, true);
        UserTopic grandChild = new UserTopic("ac", "http://www.eclipse.org", true);
        topic.addTopic(child);
        child.addTopic(grandChild);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)new MockScope('a', true)));
    }

    @Test
    public void testTocParentOfEmptyLeaf() {
        UserToc toc = new UserToc("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("ac", null, true);
        toc.addTopic(child);
        MockScope scope = new MockScope('a', false);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testTocParentOfNonEmptyLeaf() {
        UserToc toc = new UserToc("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("ac", "http://www.eclipse.org", true);
        toc.addTopic(child);
        MockScope scope = new MockScope('a', true);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testEntryParentOfEmptyLeaf() {
        UserIndexEntry entry = new UserIndexEntry("ab", true);
        UserTopic child = new UserTopic("ac", null, true);
        entry.addTopic(child);
        MockScope scope = new MockScope('a', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testEntryParentOfNonEmptyLeaf() {
        UserIndexEntry entry = new UserIndexEntry("ab", true);
        UserTopic child = new UserTopic("ac", "http://www.eclipse.org", true);
        entry.addTopic(child);
        MockScope scope = new MockScope('a', true);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testEntryGrandParentOfNonEmptyLeaf() {
        UserIndexEntry entry = new UserIndexEntry("ab", true);
        UserIndexEntry child = new UserIndexEntry("ab", true);
        UserTopic grandhild = new UserTopic("ac", "http://www.eclipse.org", true);
        entry.addEntry((IIndexEntry)child);
        child.addTopic(grandhild);
        MockScope scope = new MockScope('a', true);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }
}

