/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.scope;

import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.index.Index;
import org.eclipse.ua.tests.help.other.UserIndex;
import org.eclipse.ua.tests.help.other.UserIndexEntry;
import org.eclipse.ua.tests.help.other.UserIndexSee;
import org.eclipse.ua.tests.help.other.UserToc;
import org.eclipse.ua.tests.help.other.UserTopic;
import org.eclipse.ua.tests.help.scope.MockScope;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScopeHierarchy {
    @Test
    public void testHierarchicalToc() {
        UserToc toc = new UserToc("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        toc.addTopic(child);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testHierarchicalTocDepth3() {
        UserToc toc = new UserToc("c", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("b", "http://www.eclipse.org", true);
        toc.addTopic(child);
        UserTopic grandChild = new UserTopic("c", "http://www.eclipse.org", true);
        child.addTopic(grandChild);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalTocDepth3() {
        UserToc toc = new UserToc("a", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("b", "http://www.eclipse.org", true);
        toc.addTopic(child);
        UserTopic grandChild = new UserTopic("c", "http://www.eclipse.org", true);
        child.addTopic(grandChild);
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalToc() {
        UserToc toc = new UserToc("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        toc.addTopic(child);
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)scope));
    }

    @Test
    public void testHierarchicalTopic() {
        UserTopic topic = new UserTopic("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        topic.addTopic(child);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalTopic() {
        UserTopic topic = new UserTopic("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        topic.addTopic(child);
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalTopicThreeDeep() {
        UserTopic topic = new UserTopic("ab", "http://www.eclipse.org", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        UserTopic grandChild = new UserTopic("d", "http://www.eclipse.org", true);
        topic.addTopic(child);
        child.addTopic(grandChild);
        MockScope scope = new MockScope('d', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((ITopic)topic, (AbstractHelpScope)scope));
    }

    @Test
    public void testHierarchicalEntry() {
        UserIndexEntry entry = new UserIndexEntry("ab", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        entry.addTopic(child);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalEntry() {
        UserIndexEntry entry = new UserIndexEntry("ab", true);
        UserTopic child = new UserTopic("c", "http://www.eclipse.org", true);
        entry.addTopic(child);
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalEntryThreeDeep() {
        UserIndexEntry entry = new UserIndexEntry("a", true);
        UserIndexEntry childEntry = new UserIndexEntry("b", true);
        entry.addEntry((IIndexEntry)childEntry);
        UserTopic grandChild = new UserTopic("c", "http://www.eclipse.org", true);
        childEntry.addTopic(grandChild);
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testHierarchicalEntryThreeDeep() {
        UserIndexEntry entry = new UserIndexEntry("a", true);
        UserIndexEntry childEntry = new UserIndexEntry("c", true);
        entry.addEntry((IIndexEntry)childEntry);
        UserTopic grandChild = new UserTopic("c", "http://www.eclipse.org", true);
        childEntry.addTopic(grandChild);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testHierarchicalEntryNoInScopeSubtopic() {
        UserIndexEntry entry = new UserIndexEntry("c", true);
        UserTopic child = new UserTopic("a", "http://www.eclipse.org", true);
        entry.addTopic(child);
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testNonHierarchicalEntryNoInScopeSubtopic() {
        UserIndexEntry entry = new UserIndexEntry("c", true);
        UserTopic child = new UserTopic("a", "http://www.eclipse.org", true);
        entry.addTopic(child);
        MockScope scope = new MockScope('c', false);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetInScopeNonHierarchical() {
        IIndexSee see = this.createSee("compile", "c++");
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetInScopeNonHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("compile", "c++");
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetOutOfScopeNonHierarchical() {
        IIndexSee see = this.createSee("build", "c++");
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetOutOfScopeNonHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("build", "c++");
        MockScope scope = new MockScope('c', false);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetWithChildOutOfScopeNonHierarchical() {
        IIndexSee see = this.createSee("compilation", "build");
        MockScope scope = new MockScope('c', false);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetWithChildOutOfScopeNonHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("compilation", "build");
        MockScope scope = new MockScope('c', false);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetInScopeHierarchical() {
        IIndexSee see = this.createSee("compile", "c++");
        MockScope scope = new MockScope('c', true);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetInScopeHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("compile", "c++");
        MockScope scope = new MockScope('c', true);
        Assertions.assertTrue((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetOutOfScopeHierarchical() {
        IIndexSee see = this.createSee("build", "c++");
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetOutOfScopeHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("build", "c++");
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeTargetWithChildOutOfScopeHierarchical() {
        IIndexSee see = this.createSee("compilation", "build");
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexSee)see, (AbstractHelpScope)scope));
    }

    @Test
    public void testSeeParentTargetWithChildOutOfScopeHierarchical() {
        IIndexEntry2 entry = this.createSeeParentEntry("compilation", "build");
        MockScope scope = new MockScope('c', true);
        Assertions.assertFalse((boolean)ScopeUtils.showInTree((IIndexEntry)entry, (AbstractHelpScope)scope));
    }

    private IIndexSee createSee(String targetEntryName, String targetTopicName) {
        IIndexEntry2 entry = this.createSeeParentEntry(targetEntryName, targetTopicName);
        return entry.getSees()[0];
    }

    private IIndexEntry2 createSeeParentEntry(String targetEntryName, String targetTopicName) {
        UserIndex userIndex = new UserIndex(true);
        UserIndexEntry targetEntry = new UserIndexEntry(targetEntryName, true);
        UserIndexEntry seeParentEntry = new UserIndexEntry("compilation", true);
        userIndex.addEntry((IIndexEntry)targetEntry);
        userIndex.addEntry((IIndexEntry)seeParentEntry);
        UserTopic child = new UserTopic(targetTopicName, "http://www.eclipse.org", true);
        targetEntry.addTopic(child);
        UserIndexSee userSee = new UserIndexSee(targetEntryName, false);
        seeParentEntry.addSee(userSee);
        Index index = new Index((IIndex)userIndex);
        IIndexEntry2 entry = (IIndexEntry2)index.getEntries()[1];
        return entry;
    }
}

