/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.scope;

import org.eclipse.help.ui.internal.views.ScopeSet;
import org.eclipse.help.ui.internal.views.ScopeSetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScopeSetManagerTest {
    @Test
    public void testAddScope() {
        String scopeName = "newScope1";
        ScopeSetManager manager = new ScopeSetManager();
        ScopeSet newScope = new ScopeSet(scopeName);
        manager.add(newScope);
        manager.save();
        manager = new ScopeSetManager();
        ScopeSet set = manager.findSet(scopeName);
        Assertions.assertNotNull((Object)set);
        Assertions.assertEquals((Object)scopeName, (Object)set.getName());
    }

    @Test
    public void testAddAndRenameScope() {
        String oldScopeName = "newScope2";
        String newScopeName = "newScope3";
        ScopeSetManager manager = new ScopeSetManager();
        ScopeSet newScope = new ScopeSet(oldScopeName);
        manager.add(newScope);
        newScope.setName(newScopeName);
        manager.save();
        manager = new ScopeSetManager();
        ScopeSet set = manager.findSet(newScopeName);
        Assertions.assertNotNull((Object)set);
        Assertions.assertEquals((Object)newScopeName, (Object)set.getName());
        set = manager.findSet(oldScopeName);
        Assertions.assertNull((Object)set);
    }

    @Test
    public void testAddAndDeleteScope() {
        String scopeName = "newScope4";
        ScopeSetManager manager = new ScopeSetManager();
        ScopeSet newScope = new ScopeSet(scopeName);
        manager.add(newScope);
        manager.save();
        manager = new ScopeSetManager();
        ScopeSet set = manager.findSet(scopeName);
        Assertions.assertNotNull((Object)set);
        Assertions.assertEquals((Object)scopeName, (Object)set.getName());
        manager.remove(set);
        manager = new ScopeSetManager();
        set = manager.findSet(scopeName);
        Assertions.assertNull((Object)set);
    }
}

