/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.junit.jupiter.api.Test;

public class AnalyzerTest {
    private final String[] supportedLanguages = new String[]{"en", "pt", "ja", "zh", "cs", "de", "el", "fr", "nl", "ru", "ar"};

    @Test
    public void testEnglishAnalyzer() {
        this.checkAnalyzer("en", "en");
    }

    @Test
    public void testEnglishUsAnalyzer() {
        this.checkAnalyzer("en_us", "en");
    }

    @Test
    public void testGermanAnalyzer_de() {
        this.checkAnalyzer("de", "de");
    }

    @Test
    public void testGermanAnalyzer_de_DE() {
        this.checkAnalyzer("de_DE", "de");
    }

    @Test
    public void testJapaneseAnalyzer() {
        this.checkAnalyzer("ja", "ja");
    }

    @Test
    public void testFrenchAnalyzer() {
        this.checkAnalyzer("fr", "fr");
    }

    @Test
    public void testChineseAnalyzer() {
        this.checkAnalyzer("zh", "zh");
    }

    @Test
    public void testKoreanAnalyzer() {
        this.checkAnalyzer("ko", "ja");
    }

    @Test
    public void testRussianAnalyzer() {
        this.checkAnalyzer("ru", "ru");
    }

    @Test
    public void testGreekAnalyzer() {
        this.checkAnalyzer("el", "el");
    }

    @Test
    public void testSpanishAnalyzer() {
        this.checkAnalyzer("es", "ar");
    }

    @Test
    public void testPortugueseAnalyzer() {
        this.checkAnalyzer("pt", "pt");
    }

    @Test
    public void testDutchAnalyzer() {
        this.checkAnalyzer("nl", "nl");
    }

    @Test
    public void testCzechAnalyzer() {
        this.checkAnalyzer("cs", "cs");
    }

    @Test
    public void testArabicAnalyzer() {
        this.checkAnalyzer("ar", "ar");
    }

    @Test
    public void testHebrewAnalyzer() {
        this.checkAnalyzer("il", "ar");
    }

    private void checkAnalyzer(String language, String analyzerKind) {
        String actualLanguageAnalyzerClassName = new AnalyzerDescriptor(language).getAnalyzerClassName();
        String[] stringArray = this.supportedLanguages;
        int n = this.supportedLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String nextLocale = stringArray[n2];
            String otherLanguageAnalyzerClassName = new AnalyzerDescriptor(nextLocale).getAnalyzerClassName();
            if (nextLocale.equals(analyzerKind)) {
                ((AbstractStringAssert)Assertions.assertThat((String)otherLanguageAnalyzerClassName).as("comparing analyzer for local: " + nextLocale, new Object[0])).isEqualTo(actualLanguageAnalyzerClassName);
            } else {
                ((AbstractStringAssert)Assertions.assertThat((String)otherLanguageAnalyzerClassName).as("comparing analyzer for local: " + nextLocale, new Object[0])).isNotEqualTo((Object)actualLanguageAnalyzerClassName);
            }
            ++n2;
        }
    }
}

