/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class BasicTest {
    @Test
    public void testSearchUnfiltered() {
        SearchTestUtils.searchAllLocales("jehcyqpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchFilteredAndUnfiltered() {
        SearchTestUtils.searchAllLocales("vkrhjewiwh", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchOrWithNonexistent() {
        SearchTestUtils.searchAllLocales("vkrhjewiwh OR this_string_shouldnt_exist_in_any_doc", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchOrBothExist() {
        SearchTestUtils.searchAllLocales("vkrhjewiwh OR rugnwjfyqj", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml", "/org.eclipse.ua.tests/data/help/search/test2.xhtml"});
    }

    @Test
    public void testSearchInFiltered() {
        SearchTestUtils.searchAllLocales("\"vkrhjewiwh riehguanil\"", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchAndWithFilter() {
        SearchTestUtils.searchAllLocales("vkrhjewiwh AND riehguanil", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchInFilteredOut() {
        SearchTestUtils.searchAllLocales("gsdduvfqnh", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchInclusionAndExtension() {
        SearchTestUtils.searchAllLocales("fuejnghqjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test3.xhtml", "/org.eclipse.ua.tests/data/help/search/test4.xhtml", "/org.eclipse.ua.tests/data/help/search/test5.xhtml", "/org.eclipse.ua.tests/data/help/search/test6.xhtml"});
    }

    @Test
    public void testSearchInReplacedOut() {
        SearchTestUtils.searchAllLocales("bheufnjefa", new String[0]);
    }

    @Test
    public void testSearchInReplaceOutUsingProvider() {
        SearchTestUtils.searchAllLocales("ausjduehf", new String[]{"/org.eclipse.ua.tests/data/help/search/test6.xhtml"});
    }

    @Test
    public void testSearchInReplacemenTextUsingProvider() {
        SearchTestUtils.searchAllLocales("bheufnjefb", new String[0]);
    }

    @Test
    public void testSearchXhtmlInHtml() {
        SearchTestUtils.searchAllLocales("kejehrgaqm", new String[]{"/org.eclipse.ua.tests/data/help/search/test7.html"});
    }

    @Test
    public void testSearchXhtmlNeverFiltered() {
        SearchTestUtils.searchAllLocales("opqmenhfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test7.html"});
    }

    @Test
    public void testSearchFilteredXhtmlInHtml() {
        SearchTestUtils.searchAllLocales("hugftnhdtg", new String[]{"/org.eclipse.ua.tests/data/help/search/test7.html"});
    }

    @Test
    public void testSearchMultipleTocReference() {
        SearchTestUtils.searchAllLocales("rqfedajhtg", new String[]{"/org.eclipse.ua.tests/data/help/search/test9.htm"});
    }

    @Test
    public void testSearchMultipleNonadjacentWords() {
        SearchTestUtils.searchAllLocales("gsdduvfqnh riehguanil", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchMultipleNonadjacentExactMatch() {
        SearchTestUtils.searchAllLocales("\"gsdduvfqnh riehguanil\"", new String[0]);
    }

    @Test
    public void testSearchMultipleAdjacentExactMatch() {
        SearchTestUtils.searchAllLocales("\"vkrhjewiwh riehguanil\"", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchContentProducer() {
        SearchTestUtils.searchAllLocales("egrology", new String[]{"/org.eclipse.ua.tests/generated/Generated+Parent/Parent+page+with+searchable+word+egrology+.html"});
    }
}

