/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class EncodedCharacterSearch {
    @Test
    public void testIso8859() {
        SearchTestUtils.searchOneLocale("\u00e1guilaxaxcs", new String[]{"/org.eclipse.ua.tests/data/help/search/testnl8859.htm", "/org.eclipse.ua.tests/data/help/search/testnl8859_html5.html"}, "en");
    }

    @Test
    public void testIso8859AccentNotIgnored() {
        SearchTestUtils.searchOneLocale("aguilaxaxcs", new String[0], "en");
    }

    @Test
    public void testUtf8Accented() {
        SearchTestUtils.searchOneLocale("acfele\u00f3n", new String[]{"/org.eclipse.ua.tests/data/help/search/testnlUTF8.htm", "/org.eclipse.ua.tests/data/help/search/testnlUTF8_html5.html"}, "en");
    }

    @Test
    public void testUtf8Chinese() {
        SearchTestUtils.searchOneLocale("\u8fb2\u66c6\u65b0\u5e74", new String[]{"/org.eclipse.ua.tests/data/help/search/testnlUTF8.htm", "/org.eclipse.ua.tests/data/help/search/testnlUTF8_html5.html"}, "en");
    }

    @Test
    public void testUtf8Hebrew() {
        SearchTestUtils.searchOneLocale("\u05d0\u05b7\u05e1\u05b0\u05d8\u05b0\u05e8\u05d5\u05b9\u05e0\u05d5\u05b9\u05de\u05b0\u05d9\u05b8\u05d4) \u05dc\u05b4\u05e7\u05bc\u05d5\u05bc\u05d9 (\u05d9\u05e8\u05d7 \u05d0\u05d5 \u05e9\u05de\u05e9", new String[]{"/org.eclipse.ua.tests/data/help/search/testnlUTF8.htm", "/org.eclipse.ua.tests/data/help/search/testnlUTF8_html5.html"}, "en");
    }
}

