/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtraDirTest {
    @Test
    public void testNoScope() {
        this.performSearch("iusazemhdv", null, "/org.eclipse.ua.tests/data/help/search/test8.htm");
    }

    @Test
    public void testContainingScope() {
        this.performSearch("iusazemhdv", "/org.eclipse.ua.tests/data/help/toc/root.xml", "/org.eclipse.ua.tests/data/help/search/test8.htm");
    }

    @Test
    public void testNonContainingScope() {
        this.performSearch("iusazemhdv", "/org.eclipse.platform.doc.user/toc.xml", null);
    }

    @Test
    public void testExtradirNoScope() {
        this.performSearch("xzopsujjae", null, "/org.eclipse.ua.tests/data/help/search/extraDir/extraDoc1.htm");
    }

    @Test
    public void testExtradirCorrectScope() {
        this.performSearch("xzopsujjae", "/org.eclipse.ua.tests/data/help/toc/root.xml", "/org.eclipse.ua.tests/data/help/search/extraDir/extraDoc1.htm");
    }

    @Test
    public void testExtradirIncorrectScope() {
        this.performSearch("xzopsujjae", "/org.eclipse.platform.doc.user/toc.xml", null);
    }

    @Test
    public void testExtradirSubdirNoScope() {
        this.performSearch("mrendiqwja", null, "/org.eclipse.ua.tests/data/help/search/extraDir/subDir/extraDoc2.htm");
    }

    @Test
    public void testExtradirSubDirInScope() {
        this.performSearch("mrendiqwja", "/org.eclipse.ua.tests/data/help/toc/root.xml", "/org.eclipse.ua.tests/data/help/search/extraDir/subDir/extraDoc2.htm");
    }

    @Test
    public void testExtradirSubDirOutOfScope() {
        this.performSearch("mrendiqwja", "/org.eclipse.platform.doc.user/toc.xml", null);
    }

    @Test
    public void testExtradirLinkedOutOfScope() {
        this.performSearch("kleoiujfpn", "/org.eclipse.platform.doc.user/toc.xml", null);
    }

    @Test
    public void testExtradirLinkedNoScope() {
        this.performSearch("fuqnejwmfh", null, "/org.eclipse.ua.tests/data/help/search/extraDir3/extraDoc.htm");
    }

    @Test
    public void testExtradirLinkedInScope() {
        this.performSearch("fuqnejwmfh", "/org.eclipse.ua.tests/data/help/toc/root.xml", "/org.eclipse.ua.tests/data/help/search/extraDir3/extraDoc.htm");
    }

    @Test
    public void testExtradirLinkedWrongScope() {
        this.performSearch("fuqnejwmfh", "/org.eclipse.platform.doc.user/toc.xml", null);
    }

    private void performSearch(String searchWord, String scope, String expectedResults) {
        SearchHit[] hits;
        WorkingSet[] workingSets = null;
        if (scope != null) {
            WorkingSetManager wsm = BaseHelpSystem.getWorkingSetManager();
            ArrayList<AdaptableToc> tocs = new ArrayList<AdaptableToc>();
            StringTokenizer tok = new StringTokenizer(scope, ", \t\n");
            while (tok.hasMoreTokens()) {
                tocs.add(wsm.getAdaptableToc(tok.nextToken()));
            }
            workingSets = new WorkingSet[]{wsm.createWorkingSet("testWorkingSet", tocs.toArray(new AdaptableHelpResource[tocs.size()]))};
        }
        HashSet<String> hrefsToFind = new HashSet<String>();
        if (expectedResults != null) {
            StringTokenizer tok = new StringTokenizer(expectedResults, ", \t\n");
            while (tok.hasMoreTokens()) {
                hrefsToFind.add(tok.nextToken());
            }
        }
        HashSet<String> unexpectedHrefs = new HashSet<String>();
        SearchQuery query = new SearchQuery(searchWord, false, new ArrayList(), Platform.getNL());
        SearchResults collector = new SearchResults(workingSets, 500, Platform.getNL());
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        SearchHit[] searchHitArray = hits = collector.getSearchHits();
        int n = hits.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            String href = hit.getHref();
            int index = href.indexOf(63);
            if (index != -1) {
                href = href.substring(0, index);
            }
            if (hrefsToFind.contains(href)) {
                hrefsToFind.remove(href);
            } else {
                unexpectedHrefs.add(href);
            }
            ++n2;
        }
        if (!hrefsToFind.isEmpty() || !unexpectedHrefs.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("While searching for: " + searchWord + ",\n");
            if (!hrefsToFind.isEmpty()) {
                buf.append("Some of the expected results were not found:\n");
                for (String missedHref : hrefsToFind) {
                    buf.append(missedHref + "\n");
                }
            }
            if (!unexpectedHrefs.isEmpty()) {
                if (!hrefsToFind.isEmpty()) {
                    buf.append("\nAlso,\n");
                }
                buf.append("Found some unexpected search results:\n");
                for (String unexpectedHref : unexpectedHrefs) {
                    buf.append(unexpectedHref + "\n");
                }
            }
            Assertions.fail((String)buf.toString());
        }
    }
}

