/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.webapp.servlet.InfocenterWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.ua.tests.help.webapp.MockServletRequest;
import org.eclipse.ua.tests.help.webapp.MockServletResponse;
import org.junit.jupiter.api.Test;

public class InfocenterWorkingSetManagerTest {
    @Test
    public void testIWSMWithToc() throws IOException {
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)new MockServletRequest(), (HttpServletResponse)new MockServletResponse(), "en");
        WorkingSet wset = new WorkingSet("test");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{toc});
    }

    @Test
    public void testSaveRestoreIWSMWithToc() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{toc});
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testIWSMWithOneTopic() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        wset.setElements(new AdaptableHelpResource[]{topic1});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        this.checkCookies(resp);
    }

    @Test
    public void testIWSMWithTwoTopics() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3});
        this.checkCookies(resp);
    }

    @Test
    public void testIWSMWithThreeTopics() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        AdaptableTopic topic5 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_5_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic5);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3, topic5});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3, topic5});
        this.checkCookies(resp);
    }

    @Test
    public void testSaveRestoreIWSMWithOneTopic() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        wset.setElements(new AdaptableHelpResource[]{topic1});
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testSaveRestoreIWSMWithTwoTopics() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3});
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3});
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testSaveRestoreIWSMWithThreeTopics() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        AdaptableTopic topic5 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_5_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic5);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3, topic5});
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3, topic5});
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testIWSMWithMultipleWsets() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset1 = new WorkingSet("test3");
        WorkingSet wset2 = new WorkingSet("test4");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset1.setElements(new AdaptableHelpResource[]{topic1});
        wset2.setElements(new AdaptableHelpResource[]{topic3});
        mgr.addWorkingSet(wset1);
        mgr.addWorkingSet(wset2);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(2);
        Object[] resourcesT3 = mgr.getWorkingSet("test3").getElements();
        Assertions.assertThat((Object[])resourcesT3).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        Object[] resourcesT4 = mgr.getWorkingSet("test4").getElements();
        Assertions.assertThat((Object[])resourcesT4).containsExactly((Object[])new AdaptableHelpResource[]{topic3});
        this.checkCookies(resp);
    }

    @Test
    public void testCookieSizeOptimization() throws IOException {
        MockServletRequest req1 = new MockServletRequest();
        MockServletResponse resp1 = new MockServletResponse();
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        InfocenterWorkingSetManager mgr1 = new InfocenterWorkingSetManager((HttpServletRequest)req1, (HttpServletResponse)resp1, "en");
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        WorkingSet wset1 = new WorkingSet("test21");
        WorkingSet wset2 = new WorkingSet("test22");
        AdaptableTopic topic1 = mgr1.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr1.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        wset1.setElements(new AdaptableHelpResource[]{topic1});
        mgr1.addWorkingSet(wset1);
        wset2.setElements(new AdaptableHelpResource[]{topic1, topic3});
        mgr2.addWorkingSet(wset2);
        int length1 = this.cookieLength(resp1.getCookies());
        int length2 = this.cookieLength(resp2.getCookies());
        org.junit.jupiter.api.Assertions.assertEquals((int)(length1 + 4), (int)length2);
        this.checkCookies(resp1);
        this.checkCookies(resp2);
    }

    private int cookieLength(Cookie[] cookies) {
        int total = 0;
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            total += cookie.getValue().length();
            ++n2;
        }
        return total;
    }

    @Test
    public void testSaveRestoreIWSMWithMultipleWsets() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset1 = new WorkingSet("test3");
        WorkingSet wset2 = new WorkingSet("test4");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset1.setElements(new AdaptableHelpResource[]{topic1});
        wset2.setElements(new AdaptableHelpResource[]{topic3});
        mgr.addWorkingSet(wset1);
        mgr.addWorkingSet(wset2);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(2);
        Object[] resourcesT3 = mgr2.getWorkingSet("test3").getElements();
        Assertions.assertThat((Object[])resourcesT3).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        org.junit.jupiter.api.Assertions.assertEquals((Object)topic1, (Object)resourcesT3[0]);
        Object[] resourcesT4 = mgr2.getWorkingSet("test4").getElements();
        Assertions.assertThat((Object[])resourcesT4).containsExactly((Object[])new AdaptableHelpResource[]{topic3});
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testIWSMWithCriteria() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test5");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version")};
        criteria[0].addCriterionValue("1.0");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] readResources = readWsets[0].getCriteria();
        Assertions.assertThat((Object[])readResources).hasSize(1);
        this.checkCookies(resp);
    }

    @Test
    public void testSaveRestoreIWSMWithMCriteria() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test6");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version")};
        criteria[0].addCriterionValue("1.0");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] readResources = readWsets[0].getCriteria();
        Assertions.assertThat((Object[])readResources).hasSize(1);
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    @Test
    public void testIWSMWithMultipleCriteria() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test7");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version"), new CriterionResource("platform")};
        criteria[0].addCriterionValue("1.0");
        criteria[1].addCriterionValue("linux");
        criteria[1].addCriterionValue("MacOS");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        CriterionResource[] readResources = readWsets[0].getCriteria();
        this.checkResourceWithTwoChildren(readResources);
        this.checkCookies(resp);
    }

    @Test
    public void testSaveRestoreIWSMWithMultipleCriteria() throws IOException {
        MockServletRequest req = new MockServletRequest();
        MockServletResponse resp = new MockServletResponse();
        InfocenterWorkingSetManager mgr = new InfocenterWorkingSetManager((HttpServletRequest)req, (HttpServletResponse)resp, "en");
        WorkingSet wset = new WorkingSet("test8");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = this.createResourceWithTwoCriteria();
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        MockServletRequest req2 = new MockServletRequest();
        MockServletResponse resp2 = new MockServletResponse();
        req2.setCookies(resp.getCookies());
        InfocenterWorkingSetManager mgr2 = new InfocenterWorkingSetManager((HttpServletRequest)req2, (HttpServletResponse)resp2, "en");
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        CriterionResource[] readResources = readWsets[0].getCriteria();
        this.checkResourceWithTwoChildren(readResources);
        this.checkCookies(resp);
        this.checkCookies(resp2);
    }

    private void checkResourceWithTwoChildren(CriterionResource[] readResources) {
        CriterionResource readPlatform;
        CriterionResource readVersion;
        Assertions.assertThat((Object[])readResources).hasSize(2);
        if (readResources[0].getCriterionName().equals("version")) {
            readVersion = readResources[0];
            readPlatform = readResources[1];
        } else {
            readVersion = readResources[0];
            readPlatform = readResources[1];
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)readVersion.getCriterionName());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)readVersion.getCriterionValues().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readVersion.getCriterionValues().contains("1.0"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"platform", (Object)readPlatform.getCriterionName());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)readPlatform.getCriterionValues().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readPlatform.getCriterionValues().contains("linux"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readPlatform.getCriterionValues().contains("MacOS"));
    }

    private CriterionResource[] createResourceWithTwoCriteria() {
        CriterionResource[] criteria = new CriterionResource[2];
        criteria[0] = new CriterionResource("version");
        criteria[0].addCriterionValue("1.0");
        criteria[1] = new CriterionResource("platform");
        criteria[1].addCriterionValue("linux");
        criteria[1].addCriterionValue("MacOS");
        return criteria;
    }

    private void checkCookies(MockServletResponse resp) {
        String illegalChars = resp.getIllegalCharatersFound();
        if (illegalChars.isEmpty() || illegalChars.equals("<")) {
            return;
        }
        org.junit.jupiter.api.Assertions.fail((String)("Cookie contains these illegal characters " + illegalChars + "\""));
    }
}

