/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class MetaKeywords {
    @Test
    public void testKeywordInHtml() {
        SearchTestUtils.searchAllLocales("ydhaedrsc", new String[]{"/org.eclipse.ua.tests/data/help/search/testMeta.htm"});
    }

    @Test
    public void testKeywordInXhtml() {
        SearchTestUtils.searchAllLocales("olfrgkjrifjd", new String[]{"/org.eclipse.ua.tests/data/help/search/testMeta.xhtml"});
    }

    @Test
    public void testDescriptionInHtml() {
        Object[] hits = this.getResultDescriptions("ydhaedrsc", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"HTML Meta description", (Object)hits[0].getDescription());
    }

    @Test
    public void testDescriptionInXhtml() {
        Object[] hits = this.getResultDescriptions("olfrgkjrifjd", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"XHTML Meta description", (Object)hits[0].getDescription());
    }

    @Test
    public void testSearchDescriptionInHtml() {
        SearchTestUtils.searchAllLocales("basbanba", new String[]{"/org.eclipse.ua.tests/data/help/search/extraDir/testMeta2.htm"});
    }

    @Test
    public void testSearchDescriptionInXhtml() {
        SearchTestUtils.searchAllLocales("mfjrudjesm", new String[]{"/org.eclipse.ua.tests/data/help/search/extraDir/testMeta2.xhtml"});
    }

    private SearchHit[] getResultDescriptions(String searchWord, String nl) {
        SearchQuery query = new SearchQuery(searchWord, false, new ArrayList(), nl);
        SearchResults collector = new SearchResults(null, 500, nl);
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        return collector.getSearchHits();
    }
}

