/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.PluginIndex;
import org.eclipse.help.internal.search.QueryBuilder;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PrebuiltIndexCompatibility {
    @Test
    public void test8_4_1_IndexUnreadable() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.checkReadable("data/help/searchindex/index841"));
    }

    @Test
    public void test8_4_1LuceneIncompatible() {
        this.checkLuceneCompatible("8.4.1", false);
    }

    @Test
    public void testLatestLuceneCompatible() {
        this.checkLuceneCompatible(Version.LATEST.toString(), true);
    }

    @Test
    public void testPluginIndexEqualToItself() {
        PluginIndex index = this.createPluginIndex("data/help/searchindex/index841");
        Assertions.assertEquals((Object)index, (Object)index);
    }

    @Test
    public void testPluginIndexEquality() {
        PluginIndex index1a = this.createPluginIndex("data/help/searchindex/index841");
        PluginIndex index1b = this.createPluginIndex("data/help/searchindex/index841");
        Assertions.assertEquals((Object)index1a, (Object)index1b);
    }

    @Test
    public void testPluginIndexHash() {
        PluginIndex index1a = this.createPluginIndex("data/help/searchindex/index841");
        PluginIndex index1b = this.createPluginIndex("data/help/searchindex/index841");
        Assertions.assertEquals((int)index1a.hashCode(), (int)index1b.hashCode());
    }

    @Test
    public void testPluginIndexInequality() {
        PluginIndex index1 = this.createPluginIndex("data/help/searchindex/index841");
        PluginIndex index2 = this.createPluginIndex("data/help/searchindex/index800");
        Assertions.assertNotEquals((Object)index1, (Object)index2);
    }

    private void checkReadable(String indexPath) throws IOException, CorruptIndexException {
        block21: {
            IPath path = IPath.fromOSString((String)indexPath);
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            URL resolved = FileLocator.resolve((URL)url);
            if ("file".equals(resolved.getProtocol())) {
                String filePath = resolved.getFile();
                QueryBuilder queryBuilder = new QueryBuilder("eclipse", new AnalyzerDescriptor("en-us"));
                Query luceneQuery = queryBuilder.getLuceneQuery(new ArrayList(), false);
                try {
                    Throwable throwable = null;
                    Object var11_12 = null;
                    try (NIOFSDirectory luceneDirectory = new NIOFSDirectory(new File(filePath).toPath());){
                        Throwable throwable2 = null;
                        Object var14_17 = null;
                        try (DirectoryReader luceneDirectoryReader = DirectoryReader.open((Directory)luceneDirectory);){
                            IndexSearcher searcher = new IndexSearcher((IndexReader)luceneDirectoryReader);
                            TopDocs hits = searcher.search(luceneQuery, 500);
                            Assertions.assertTrue((hits.totalHits != null ? 1 : 0) != 0);
                            break block21;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IndexFormatTooOldException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            Assertions.fail((String)"Cannot resolve to file protocol");
        }
    }

    public PluginIndex createPluginIndex(String versionDirectory) {
        SearchIndexWithIndexingProgress index = BaseHelpSystem.getLocalSearchManager().getIndex("en_us".toString());
        BaseHelpSystem.getLocalSearchManager().ensureIndexUpdated((IProgressMonitor)new NullProgressMonitor(), index);
        PluginIndex pluginIndex = new PluginIndex("org.eclipse.ua.tests", "data/help/searchindex/" + versionDirectory, (SearchIndex)index);
        return pluginIndex;
    }

    private void checkLuceneCompatible(String version, boolean expected) {
        SearchIndexWithIndexingProgress index = BaseHelpSystem.getLocalSearchManager().getIndex("en_us".toString());
        BaseHelpSystem.getLocalSearchManager().ensureIndexUpdated((IProgressMonitor)new NullProgressMonitor(), index);
        Assertions.assertEquals((Object)expected, (Object)index.isLuceneCompatible(version));
    }
}

