/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.junit.jupiter.api.Test;

public class SearchCheatsheet {
    public SearchHit[] findHits(String searchWord) {
        SearchQuery query = new SearchQuery(searchWord, false, new ArrayList(), Platform.getNL());
        SearchResults collector = new SearchResults(null, 10, Platform.getNL());
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        return collector.getSearchHits();
    }

    @Test
    public void testCheatSheetTitleSearch() {
        SearchHit[] hits = this.findHits("CSTitle_AhB4U8");
        this.checkForCheatSheetMatch(hits);
    }

    @Test
    public void testCheatSheetIntroSearch() {
        SearchHit[] hits = this.findHits("CSIntro_AhB4U8");
        this.checkForCheatSheetMatch(hits);
    }

    @Test
    public void testCheatSheetItemSearch() {
        SearchHit[] hits = this.findHits("CSItem_AhB4U8");
        this.checkForCheatSheetMatch(hits);
        hits = this.findHits("CSItemDesc_AhB4U8");
        this.checkForCheatSheetMatch(hits);
        hits = this.findHits("CSItemCompletion_AhB4U8");
        this.checkForCheatSheetMatch(hits);
    }

    @Test
    public void testCheatSheetSubitemSearch() {
        SearchHit[] hits = this.findHits("SubItem1_AhB4U8");
        this.checkForCheatSheetMatch(hits);
        hits = this.findHits("SubItem2_AhB4U8");
        this.checkForCheatSheetMatch(hits);
        hits = this.findHits("ConditionalSubItem_AhB4U8");
        this.checkForCheatSheetMatch(hits);
    }

    @Test
    public void testCompositeTitleSearch() {
        SearchHit[] hits = this.findHits("CompositeName_AhB4U8");
        this.checkForCompositeMatch(hits);
    }

    @Test
    public void testCompositeTaskSearch() {
        Object[] hits = this.findHits("TaskName_AhB4U8");
        this.checkForCompositeMatch((SearchHit[])hits);
        hits = this.findHits("TaskIntro_AhB4U8");
        this.checkForCompositeMatch((SearchHit[])hits);
        hits = this.findHits("TaskCompletion_AhB4U8");
        this.checkForCompositeMatch((SearchHit[])hits);
        hits = this.findHits("TaskId_AhB4U8");
        Assertions.assertThat((Object[])hits).isEmpty();
    }

    @Test
    public void testCompositeTaskGroupSearch() {
        SearchHit[] hits = this.findHits("TaskGroup_AhB4U8");
        this.checkForCompositeMatch(hits);
        hits = this.findHits("TaskGroupIntro_AhB4U8");
        this.checkForCompositeMatch(hits);
        hits = this.findHits("TaskGroupCompletion_AhB4U8");
        this.checkForCompositeMatch(hits);
    }

    private void checkForCheatSheetMatch(SearchHit[] hits) {
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/cheatsheet/search/CSSearchTest.xml", (Object)this.ignoreQuery(hits[0].getHref()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hits[0].getDescription().startsWith("CSIntro_AhB4U8 This cheat sheet is used to test search."));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.eclipse.ui.cheatsheets/org.eclipse.ua.tests.cheatsheet.searchTest", (Object)hits[0].getId());
    }

    private void checkForCompositeMatch(SearchHit[] hits) {
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/cheatsheet/search/CompositeSearchTest.xml", (Object)this.ignoreQuery(hits[0].getHref()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)hits[0].getDescription().startsWith("Intro text TaskGroupIntro_AhB4U8"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.eclipse.ui.cheatsheets/org.eclipse.ua.tests.composite.searchTest", (Object)hits[0].getId());
    }

    private String ignoreQuery(String href) {
        int index = href.indexOf(63);
        if (index != -1) {
            return href.substring(0, index);
        }
        return href;
    }
}

