/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.assertj.core.api.Assertions;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class SearchParticipantTest {
    @Test
    public void testSearchFirstWordInFirstDoc() {
        SearchTestUtils.searchAllLocales("jkijkijkk", new String[]{"/org.eclipse.ua.tests/participant1.xml"});
    }

    @Test
    public void testSearchLastWordInFirstDoc() {
        SearchTestUtils.searchAllLocales("frgeded", new String[]{"/org.eclipse.ua.tests/participant1.xml"});
    }

    @Test
    public void testSearchUsingAndInFirstDoc() {
        SearchTestUtils.searchAllLocales("jkijkijkk AND frgeded", new String[]{"/org.eclipse.ua.tests/participant1.xml"});
    }

    @Test
    public void testSearchUsingAndInSeparateDocs() {
        SearchTestUtils.searchAllLocales("jduehdye and olhoykk", new String[0]);
    }

    @Test
    public void testSearchExactMatch() {
        SearchTestUtils.searchAllLocales("\"jkijkijkk frgeded\"", new String[]{"/org.eclipse.ua.tests/participant1.xml"});
    }

    @Test
    public void testSearchExactMatchNotFound() {
        SearchTestUtils.searchAllLocales("\"frgeded jkijkijkk\"", new String[0]);
    }

    @Test
    public void testSearchWordInSecondDoc() {
        SearchTestUtils.searchAllLocales("olhoykk", new String[]{"/org.eclipse.ua.tests/participant2.xml"});
    }

    @Test
    public void testReturnedTitle() {
        Object[] hits = SearchTestUtils.getSearchHits("jkijkijkk", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Title1", (Object)hits[0].getLabel());
    }

    @Test
    public void testReturnedSummary() {
        Object[] hits = SearchTestUtils.getSearchHits("jkijkijkk", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Summary1", (Object)hits[0].getSummary());
    }
}

