/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.assertj.core.api.Assertions;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class SearchParticipantXMLTest {
    @Test
    public void testSearchFirstWordInFirstDoc() {
        SearchTestUtils.searchAllLocales("jfplepdl", new String[]{"/org.eclipse.ua.tests/data/help/search/participant_xml_1.xml"});
    }

    @Test
    public void testSearchLastWordInFirstDoc() {
        SearchTestUtils.searchAllLocales("memdjkemd", new String[]{"/org.eclipse.ua.tests/data/help/search/participant_xml_1.xml"});
    }

    @Test
    public void testSearchWordFromOuterElement() {
        SearchTestUtils.searchAllLocales("odoeofoedo", new String[]{"/org.eclipse.ua.tests/data/help/search/participant_xml_2.xml"});
    }

    @Test
    public void testSearchWordFromNestedElement() {
        SearchTestUtils.searchAllLocales("odkeofkeks", new String[]{"/org.eclipse.ua.tests/data/help/search/participant_xml_2.xml"});
    }

    @Test
    public void testReturnedTitle() {
        Object[] hits = SearchTestUtils.getSearchHits("jfplepdl", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Participant XML 1", (Object)hits[0].getLabel());
    }

    @Test
    public void testReturnedSummary() {
        Object[] hits = SearchTestUtils.getSearchHits("jfplepdl", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Summary for file Participant XML1", (Object)hits[0].getSummary());
    }

    @Test
    public void testReturnedTitleNestedCase() {
        Object[] hits = SearchTestUtils.getSearchHits("odoeofoedo", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Participant XML 2 - tests nesting", (Object)hits[0].getLabel());
    }

    @Test
    public void testReturnedSummaryNestedCase() {
        Object[] hits = SearchTestUtils.getSearchHits("odoeofoedo", "en");
        Assertions.assertThat((Object[])hits).hasSize(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Summary for file Participant XML2", (Object)hits[0].getSummary());
    }
}

