/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResult;
import org.eclipse.help.internal.search.federated.LocalHelp;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.search.AbstractSearchProcessor;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchResult;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.search.SearchProcessorInfo;
import org.eclipse.ua.tests.help.search.WrappedSearchProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SearchProcessorTest {
    @Test
    void testPreSearch() {
        AbstractSearchProcessor processor = new AbstractSearchProcessor(){

            public SearchProcessorInfo preSearch(String query) {
                SearchProcessorInfo info = new SearchProcessorInfo();
                info.setQuery("jkijkijkk");
                return info;
            }

            public ISearchResult[] postSearch(String query, ISearchResult[] results) {
                return null;
            }
        };
        this.test(processor, new String[]{"/org.eclipse.ua.tests/participant1.xml"});
    }

    @Test
    void testPostSearch() {
        AbstractSearchProcessor processor = new AbstractSearchProcessor(){

            public SearchProcessorInfo preSearch(String query) {
                SearchProcessorInfo info = new SearchProcessorInfo();
                info.setQuery("jkijkijkk");
                return info;
            }

            public ISearchResult[] postSearch(String query, ISearchResult[] results) {
                Assertions.assertEquals((Object)"jkijkijkk", (Object)query);
                Assertions.assertEquals((int)1, (int)results.length);
                Assertions.assertEquals((Object)"/org.eclipse.ua.tests/participant1.xml", (Object)SearchProcessorTest.withoutQueryPart(results[0].getHref()));
                SearchResult addedResult = new SearchResult();
                addedResult.setHref("/org.eclipse.ua.tests/added");
                return new ISearchResult[]{addedResult};
            }
        };
        this.test(processor, new String[]{"/org.eclipse.ua.tests/added"});
    }

    @Test
    void testExtendedPostSearch() {
        AbstractSearchProcessor processor = new AbstractSearchProcessor(){

            public SearchProcessorInfo preSearch(String query) {
                SearchProcessorInfo info = new SearchProcessorInfo();
                info.setQuery("olhoykk");
                return info;
            }

            public ISearchResult[] postSearch(String query, ISearchResult[] results) {
                return null;
            }

            public ISearchResult[] postSearch(String query, String originalQuery, ISearchResult[] results, String locale, IHelpResource[] scopes) {
                Assertions.assertEquals((Object)"olhoykk", (Object)query);
                Assertions.assertEquals((Object)"SearchProcessorTest", (Object)originalQuery);
                Assertions.assertEquals((int)1, (int)results.length);
                Assertions.assertEquals((Object)"/org.eclipse.ua.tests/participant2.xml", (Object)SearchProcessorTest.withoutQueryPart(results[0].getHref()));
                Assertions.assertEquals((Object)new SearchQuery().getLocale(), (Object)locale);
                Assertions.assertNull((Object)scopes);
                SearchResult addedResult = new SearchResult();
                addedResult.setHref("/org.eclipse.ua.tests/added2");
                return new ISearchResult[]{addedResult};
            }
        };
        this.test(processor, new String[]{"/org.eclipse.ua.tests/added2"});
    }

    @Test
    void testNullProcessor() {
        AbstractSearchProcessor processor = new AbstractSearchProcessor(){

            public SearchProcessorInfo preSearch(String query) {
                Assertions.assertEquals((Object)"SearchProcessorTest", (Object)query);
                return null;
            }

            public ISearchResult[] postSearch(String query, ISearchResult[] results) {
                return null;
            }
        };
        this.test(processor, new String[0]);
    }

    private void test(AbstractSearchProcessor processor, String[] expected) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (AutoCloseable autoClosable = WrappedSearchProcessor.set(processor);){
                Object[] hits = SearchProcessorTest.search("SearchProcessorTest");
                Assertions.assertArrayEquals((Object[])expected, (Object[])hits);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((Throwable)e);
        }
    }

    private static String[] search(String query) throws Exception {
        final ArrayList foundHrefs = new ArrayList();
        ISearchEngineResultCollector collector = new ISearchEngineResultCollector(){

            public void accept(ISearchEngineResult searchResult) {
                foundHrefs.add(SearchProcessorTest.withoutQueryPart(searchResult.getHref()));
            }

            public void accept(ISearchEngineResult[] searchResults) {
                ISearchEngineResult[] iSearchEngineResultArray = searchResults;
                int n = searchResults.length;
                int n2 = 0;
                while (n2 < n) {
                    ISearchEngineResult searchResult = iSearchEngineResultArray[n2];
                    foundHrefs.add(SearchProcessorTest.withoutQueryPart(searchResult.getHref()));
                    ++n2;
                }
            }

            public void error(IStatus status) {
                Assertions.fail((Throwable)new RuntimeException(status.getMessage(), status.getException()));
            }
        };
        new LocalHelp().run(query, (ISearchScope)new LocalHelpScope(null, false), collector, (IProgressMonitor)new NullProgressMonitor());
        Collections.sort(foundHrefs);
        return (String[])foundHrefs.toArray(String[]::new);
    }

    private static String withoutQueryPart(String href) {
        return href.indexOf(63) < 0 ? href : href.substring(0, href.indexOf(63));
    }
}

