/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class SearchRanking {
    public SearchHit[] findHits(String searchWord) {
        SearchQuery query = new SearchQuery(searchWord, false, new ArrayList(), Platform.getNL());
        SearchResults collector = new SearchResults(null, 10, Platform.getNL());
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        return collector.getSearchHits();
    }

    @Test
    public void testTitleBoost1() {
        Object[] hits = SearchTestUtils.getSearchHits("mjuhgt", "en");
        Arrays.sort(hits);
        Assertions.assertThat((Object[])hits).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest1b.htm", (Object)this.getPath((SearchHit)hits[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest1a.htm", (Object)this.getPath((SearchHit)hits[1]));
    }

    @Test
    public void testTitleBoost2() {
        Object[] hits = SearchTestUtils.getSearchHits("odrgtb", "en");
        Arrays.sort(hits);
        Assertions.assertThat((Object[])hits).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest1a.htm", (Object)this.getPath((SearchHit)hits[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest1b.htm", (Object)this.getPath((SearchHit)hits[1]));
    }

    @Test
    public void testConsecutiveWords1() {
        Object[] hits = SearchTestUtils.getSearchHits("iduhnf xaqsdab", "en");
        Arrays.sort(hits);
        Assertions.assertThat((Object[])hits).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest2b.htm", (Object)this.getPath((SearchHit)hits[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest2a.htm", (Object)this.getPath((SearchHit)hits[1]));
    }

    @Test
    public void testConsecutiveWords2() {
        Object[] hits = SearchTestUtils.getSearchHits("xaqsdab iduhnf", "en");
        Arrays.sort(hits);
        Assertions.assertThat((Object[])hits).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest2a.htm", (Object)this.getPath((SearchHit)hits[0]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/search/extraDir/ranking/ranktest2b.htm", (Object)this.getPath((SearchHit)hits[1]));
    }

    private String getPath(SearchHit hit) {
        String href = hit.getHref();
        int query = href.indexOf(63);
        return query < 0 ? href : href.substring(0, query);
    }
}

