/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.junit.jupiter.api.Assertions;

public class SearchTestUtils {
    public static void searchAllLocales(String searchWord, String[] hrefs) {
        SearchTestUtils.searchOneLocale(searchWord, hrefs, "en");
        SearchTestUtils.searchOneLocale(searchWord, hrefs, "de");
    }

    public static void searchOneLocale(String searchWord, String[] hrefs, String nl) {
        String unexpected = SearchTestUtils.searchForExpectedResults(searchWord, hrefs, nl);
        if (unexpected != null) {
            Assertions.fail((String)unexpected);
        }
    }

    public static String searchForExpectedResults(String searchWord, String[] hrefs, String nl) {
        SearchHit[] hits;
        HashSet<String> hrefsToFind = new HashSet<String>();
        HashSet<String> unexpectedHrefs = new HashSet<String>();
        hrefsToFind.addAll(Arrays.asList(hrefs));
        SearchHit[] searchHitArray = hits = SearchTestUtils.getSearchHits(searchWord, nl);
        int n = hits.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            String href = hit.getHref();
            int index = href.indexOf(63);
            if (index != -1) {
                href = href.substring(0, index);
            }
            if (hrefsToFind.contains(href)) {
                hrefsToFind.remove(href);
            } else {
                unexpectedHrefs.add(href);
            }
            ++n2;
        }
        if (!hrefsToFind.isEmpty() || !unexpectedHrefs.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("While searching for: " + searchWord + ",\n");
            if (!hrefsToFind.isEmpty()) {
                buf.append("Some of the expected results were not found:\n");
                for (String missedHref : hrefsToFind) {
                    buf.append(missedHref + "\n");
                }
            }
            if (!unexpectedHrefs.isEmpty()) {
                if (!hrefsToFind.isEmpty()) {
                    buf.append("\nAlso,\n");
                }
                buf.append("Found some unexpected search results:\n");
                for (String unexpectedHref : unexpectedHrefs) {
                    buf.append(unexpectedHref + "\n");
                }
            }
            return buf.toString();
        }
        return null;
    }

    public static SearchHit[] getSearchHits(String searchWord, String nl) {
        SearchQuery query = new SearchQuery(searchWord, false, new ArrayList(), nl);
        SearchResults collector = new SearchResults(null, 500, nl);
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, (ISearchHitCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        SearchHit[] hits = collector.getSearchHits();
        return hits;
    }
}

