/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import org.eclipse.ua.tests.help.search.SearchTestUtils;
import org.junit.jupiter.api.Test;

public class WildcardTest {
    @Test
    public void testSearchWithStar() {
        SearchTestUtils.searchAllLocales("jehc*qpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchWithTwoStars() {
        SearchTestUtils.searchAllLocales("jehc*qp*js", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchWithStarReplacingThreeChars() {
        SearchTestUtils.searchAllLocales("jehc*fjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchWithStarReplacingSpace() {
        SearchTestUtils.searchAllLocales("jehcyqpfjs*vkrhjewiwh", new String[0]);
    }

    @Test
    public void testSearchWithQuestionMark() {
        SearchTestUtils.searchAllLocales("jehc?qpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchWithTwoQuestionMarks() {
        SearchTestUtils.searchAllLocales("j?hc?qpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchQuestionMarkCannotReplaceTwoChars() {
        SearchTestUtils.searchAllLocales("jehc?pfjs", new String[0]);
    }

    @Test
    public void testSearchSuccessiveQuestionMarks() {
        SearchTestUtils.searchAllLocales("jehc??pfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchLeadingStar() {
        SearchTestUtils.searchAllLocales("*hcyqpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }

    @Test
    public void testSearchLeadingQuestionMark() {
        SearchTestUtils.searchAllLocales("?ehcyqpfjs", new String[]{"/org.eclipse.ua.tests/data/help/search/test1.xhtml"});
    }
}

