/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.search;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.WorkingSetScope;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WorkingSetManagerTest {
    private WorkingSet[] workingSets;

    @BeforeEach
    public void setUp() throws Exception {
        WorkingSetManager manager = new WorkingSetManager();
        manager.restoreState();
        WorkingSet[] workingSetArray = this.workingSets = manager.getWorkingSets();
        int n = this.workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            WorkingSet workingSet = workingSetArray[n2];
            manager.removeWorkingSet(workingSet);
            ++n2;
        }
        manager.saveState();
    }

    @AfterEach
    public void tearDown() throws Exception {
        WorkingSet[] wsetsToRemove;
        WorkingSetManager manager = new WorkingSetManager();
        WorkingSet[] workingSetArray = wsetsToRemove = manager.getWorkingSets();
        int n = wsetsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            WorkingSet element = workingSetArray[n2];
            manager.removeWorkingSet(element);
            ++n2;
        }
        workingSetArray = this.workingSets;
        n = this.workingSets.length;
        n2 = 0;
        while (n2 < n) {
            WorkingSet workingSet = workingSetArray[n2];
            manager.addWorkingSet(workingSet);
            ++n2;
        }
        manager.saveState();
    }

    @Test
    public void testNewWSM() {
        WorkingSetManager mgr = new WorkingSetManager();
        Assertions.assertThat((Object[])mgr.getWorkingSets()).isEmpty();
        WorkingSetManager mgr2 = new WorkingSetManager();
        org.junit.jupiter.api.Assertions.assertEquals((Object)mgr, (Object)mgr2);
        org.junit.jupiter.api.Assertions.assertEquals((int)mgr.hashCode(), (int)mgr2.hashCode());
    }

    @Test
    public void testWSMWithToc() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{toc});
    }

    @Test
    public void testWSMWithTocContainsThatToc() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        AdaptableToc toc = mgr.getAdaptableToc(tocs[0].getHref());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        WorkingSetScope scope = new WorkingSetScope("test", (IHelpWorkingSetManager)mgr, "scope");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)tocs[0]));
    }

    @Test
    public void testWSMWithTocContainsNoOtherToc() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        AdaptableToc toc = mgr.getAdaptableToc(tocs[0].getHref());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        WorkingSetScope scope = new WorkingSetScope("test", (IHelpWorkingSetManager)mgr, "scope");
        int i = 1;
        while (i < tocs.length) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope((IToc)tocs[i]));
            ++i;
        }
    }

    @Test
    public void testWSMWithTocContainsThatTocsTopics() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        AdaptableToc toc = mgr.getAdaptableToc(tocs[0].getHref());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        WorkingSetScope scope = new WorkingSetScope("test", (IHelpWorkingSetManager)mgr, "scope");
        int i = 1;
        while (i < tocs.length) {
            ITopic[] topics;
            ITopic[] iTopicArray = topics = tocs[i].getTopics();
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                org.junit.jupiter.api.Assertions.assertFalse((boolean)scope.inScope(topic));
                ++n2;
            }
            ++i;
        }
    }

    @Test
    public void testWSMWithTocContainsNoOtherTocsTopics() {
        ITopic[] topics;
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        AdaptableToc toc = mgr.getAdaptableToc(tocs[0].getHref());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        WorkingSetScope scope = new WorkingSetScope("test", (IHelpWorkingSetManager)mgr, "scope");
        ITopic[] iTopicArray = topics = tocs[0].getTopics();
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic topic = iTopicArray[n2];
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope(topic));
            ++n2;
        }
    }

    @Test
    public void testSaveRestoreWSMWithToc() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        wset.setElements(new AdaptableHelpResource[]{toc});
        mgr.addWorkingSet(wset);
        mgr.saveState();
        WorkingSetManager mgr2 = new WorkingSetManager();
        mgr2.restoreState();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactly((Object[])new AdaptableHelpResource[]{toc});
    }

    @Test
    public void testSaveRestoreWSMWithAllTocs() {
        WorkingSetManager mgr = new WorkingSetManager();
        this.createWsetWithAllTocs(mgr, "test");
        mgr.saveState();
        WorkingSetManager mgr2 = new WorkingSetManager();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        Assertions.assertThat((Object[])resources).hasSize(tocs.length);
    }

    @Test
    public void testTocInScopeWithAllTocs() {
        Toc[] tocs;
        WorkingSetManager mgr = new WorkingSetManager();
        this.createWsetWithAllTocs(mgr, "test1");
        mgr.saveState();
        WorkingSetScope scope = new WorkingSetScope("test1", (IHelpWorkingSetManager)mgr, "scope");
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope((IToc)toc));
            ++n2;
        }
    }

    @Test
    public void testTopLevelTopicsInScopeWithAllTocs() {
        Toc[] tocs;
        WorkingSetManager mgr = new WorkingSetManager();
        this.createWsetWithAllTocs(mgr, "test1a");
        WorkingSetScope scope = new WorkingSetScope("test1a", (IHelpWorkingSetManager)mgr, "scope");
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic[] topics;
            Toc toc = tocArray[n2];
            ITopic[] iTopicArray = topics = toc.getTopics();
            int n3 = topics.length;
            int n4 = 0;
            while (n4 < n3) {
                ITopic topic = iTopicArray[n4];
                org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope(topic));
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testSecondLevelTopicsInScopeWithAllTocs() {
        Toc[] tocs;
        WorkingSetManager mgr = new WorkingSetManager();
        this.createWsetWithAllTocs(mgr, "test1b");
        WorkingSetScope scope = new WorkingSetScope("test1b", (IHelpWorkingSetManager)mgr, "scope");
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic[] topics;
            Toc toc = tocArray[n2];
            ITopic[] iTopicArray = topics = toc.getTopics();
            int n3 = topics.length;
            int n4 = 0;
            while (n4 < n3) {
                ITopic[] subtopics;
                ITopic topic = iTopicArray[n4];
                ITopic[] iTopicArray2 = subtopics = topic.getSubtopics();
                int n5 = subtopics.length;
                int n6 = 0;
                while (n6 < n5) {
                    ITopic subtopic = iTopicArray2[n6];
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)scope.inScope(subtopic));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createWsetWithAllTocs(WorkingSetManager mgr, String name) {
        Toc[] tocs;
        WorkingSet wset = new WorkingSet(name);
        ArrayList<AdaptableToc> tocList = new ArrayList<AdaptableToc>();
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            tocList.add(mgr.getAdaptableToc(toc.getHref()));
            ++n2;
        }
        wset.setElements((AdaptableHelpResource[])tocList.toArray(new AdaptableToc[0]));
        mgr.addWorkingSet(wset);
    }

    @Test
    public void testWSMWithTopics() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3});
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3});
    }

    @Test
    public void testSaveRestoreWSMWithTopics() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test2");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset.setElements(new AdaptableHelpResource[]{topic1, topic3});
        mgr.addWorkingSet(wset);
        mgr.saveState();
        WorkingSetManager mgr2 = new WorkingSetManager();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] resources = readWsets[0].getElements();
        Assertions.assertThat((Object[])resources).containsExactlyInAnyOrder((Object[])new AdaptableHelpResource[]{topic1, topic3});
    }

    @Test
    public void testWSMWithMultipleWsets() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset1 = new WorkingSet("test3");
        WorkingSet wset2 = new WorkingSet("test4");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset1.setElements(new AdaptableHelpResource[]{topic1});
        wset2.setElements(new AdaptableHelpResource[]{topic3});
        mgr.addWorkingSet(wset1);
        mgr.addWorkingSet(wset2);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(2);
        Object[] resourcesT3 = mgr.getWorkingSet("test3").getElements();
        Assertions.assertThat((Object[])resourcesT3).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        Object[] resourcesT4 = mgr.getWorkingSet("test4").getElements();
        Assertions.assertThat((Object[])resourcesT4).containsExactly((Object[])new AdaptableHelpResource[]{topic3});
    }

    @Test
    public void testSaveRestoreWSMWithMultipleWsets() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset1 = new WorkingSet("test3");
        WorkingSet wset2 = new WorkingSet("test4");
        AdaptableTopic topic1 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_1_");
        AdaptableTopic topic3 = mgr.getAdaptableTopic("/org.eclipse.ua.tests/data/help/toc/root.xml_3_");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)topic3);
        wset1.setElements(new AdaptableHelpResource[]{topic1});
        wset2.setElements(new AdaptableHelpResource[]{topic3});
        mgr.addWorkingSet(wset1);
        mgr.addWorkingSet(wset2);
        WorkingSetManager mgr2 = new WorkingSetManager();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(2);
        Object[] resourcesT3 = mgr2.getWorkingSet("test3").getElements();
        Assertions.assertThat((Object[])resourcesT3).containsExactly((Object[])new AdaptableHelpResource[]{topic1});
        Object[] resourcesT4 = mgr2.getWorkingSet("test4").getElements();
        Assertions.assertThat((Object[])resourcesT4).containsExactly((Object[])new AdaptableHelpResource[]{topic3});
    }

    @Test
    public void testWSMWithCriteria() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test5");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version")};
        criteria[0].addCriterionValue("1.0");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] readResources = readWsets[0].getCriteria();
        Assertions.assertThat((Object[])readResources).hasSize(1);
    }

    @Test
    public void testSaveRestoreWSMWithMCriteria() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test6");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version")};
        criteria[0].addCriterionValue("1.0");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        mgr.saveState();
        WorkingSetManager mgr2 = new WorkingSetManager();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        Object[] readResources = readWsets[0].getCriteria();
        Assertions.assertThat((Object[])readResources).hasSize(1);
    }

    @Test
    public void testWSMWithMultipleCriteria() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test7");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = new CriterionResource[]{new CriterionResource("version"), new CriterionResource("platform")};
        criteria[0].addCriterionValue("1.0");
        criteria[1].addCriterionValue("linux");
        criteria[1].addCriterionValue("MacOS");
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        Object[] readWsets = mgr.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        CriterionResource[] readResources = readWsets[0].getCriteria();
        this.checkResourceWithTwoChildren(readResources);
    }

    @Test
    public void testSaveRestoreWSMWithMultipleCriteria() {
        WorkingSetManager mgr = new WorkingSetManager();
        WorkingSet wset = new WorkingSet("test8");
        AdaptableToc toc = mgr.getAdaptableToc("/org.eclipse.ua.tests/data/help/toc/root.xml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)toc);
        wset.setElements(new AdaptableHelpResource[]{toc});
        CriterionResource[] criteria = this.createResourceWithTwoCriteria();
        wset.setCriteria(criteria);
        mgr.addWorkingSet(wset);
        mgr.saveState();
        WorkingSetManager mgr2 = new WorkingSetManager();
        Object[] readWsets = mgr2.getWorkingSets();
        Assertions.assertThat((Object[])readWsets).hasSize(1);
        CriterionResource[] readResources = readWsets[0].getCriteria();
        this.checkResourceWithTwoChildren(readResources);
    }

    private void checkResourceWithTwoChildren(CriterionResource[] readResources) {
        CriterionResource readPlatform;
        CriterionResource readVersion;
        Assertions.assertThat((Object[])readResources).hasSize(2);
        if (readResources[0].getCriterionName().equals("version")) {
            readVersion = readResources[0];
            readPlatform = readResources[1];
        } else {
            readVersion = readResources[0];
            readPlatform = readResources[1];
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"version", (Object)readVersion.getCriterionName());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)readVersion.getCriterionValues().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readVersion.getCriterionValues().contains("1.0"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"platform", (Object)readPlatform.getCriterionName());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)readPlatform.getCriterionValues().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readPlatform.getCriterionValues().contains("linux"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)readPlatform.getCriterionValues().contains("MacOS"));
    }

    private CriterionResource[] createResourceWithTwoCriteria() {
        CriterionResource[] criteria = new CriterionResource[2];
        criteria[0] = new CriterionResource("version");
        criteria[0].addCriterionValue("1.0");
        criteria[1] = new CriterionResource("platform");
        criteria[1].addCriterionValue("linux");
        criteria[1].addCriterionValue("MacOS");
        return criteria;
    }
}

