/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.junit.jupiter.api.Test;

public class EnabledTopicTest {
    @Test
    public void testEnabledTopic() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((ITopic)new ETopic("T1", true)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((ITopic)new ETopic("T2", false)));
    }

    @Test
    public void testEnabledTopicsEmptyArray() throws Exception {
        Object[] enabled = EnabledTopicUtils.getEnabled((ITopic[])new ITopic[0]);
        Assertions.assertThat((Object[])enabled).isEmpty();
    }

    @Test
    public void testEnabledTopicsAllEnabled() throws Exception {
        ITopic[] topics = new ITopic[]{new ETopic("T1", true), new ETopic("T2", true)};
        Object[] enabled = EnabledTopicUtils.getEnabled((ITopic[])topics);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])enabled).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getLabel()).isEqualTo("T1");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getLabel()).isEqualTo("T2");
        }});
    }

    @Test
    public void testEnabledTopicsAllDisabled() throws Exception {
        ITopic[] topics = new ITopic[]{new ETopic("T1", false), new ETopic("T2", false)};
        Object[] enabled = EnabledTopicUtils.getEnabled((ITopic[])topics);
        Assertions.assertThat((Object[])enabled).isEmpty();
    }

    @Test
    public void testEnabledTopicsMix() throws Exception {
        ITopic[] topics = new ITopic[]{new ETopic("T1", true), new ETopic("T2", false), new ETopic("T3", true), new ETopic("T4", false)};
        Object[] enabled = EnabledTopicUtils.getEnabled((ITopic[])topics);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])enabled).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getLabel()).isEqualTo("T1");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getLabel()).isEqualTo("T3");
        }});
    }

    @Test
    public void testNoHref() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testNoHrefValidChild() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        noHref.addSubTopic(new ETopic("T1", true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testNoHrefInvalidChild() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        noHref.addSubTopic(new ETopic("T1", false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testNoHrefMixedChildren() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        noHref.addSubTopic(new ETopic("T1", false));
        noHref.addSubTopic(new ETopic("T2", true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testNoHrefValidGrandchild() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        NoHrefTopic subTopic = new NoHrefTopic("N2");
        noHref.addSubTopic(subTopic);
        subTopic.addSubTopic(new ETopic("T2", true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testNoHrefInvalidGrandchild() {
        NoHrefTopic noHref = new NoHrefTopic("N1");
        NoHrefTopic subTopic = new NoHrefTopic("N2");
        noHref.addSubTopic(subTopic);
        subTopic.addSubTopic(new ETopic("T2", false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((ITopic)noHref));
    }

    @Test
    public void testEmptyIndexEntry() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testEnabledIndexEntry() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        entry1.addTopic(new ETopic("T1", true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testDisabledIndexEntry() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        entry1.addTopic(new ETopic("T1", false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testMixedIndexEntry() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        entry1.addTopic(new ETopic("T1", true));
        entry1.addTopic(new ETopic("T2", false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testIndexEntryEnabledChild() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        entry2.addTopic(new ETopic("T1", true));
        entry1.addSubEntry(entry2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testIndexEntryEnabledGrandChild() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        EIndexEntry entry3 = new EIndexEntry("ghi");
        entry1.addSubEntry(entry2);
        entry2.addSubEntry(entry3);
        entry3.addTopic(new ETopic("T1", true));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testIndexEntryDisabledChild() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        entry2.addTopic(new ETopic("T1", false));
        entry1.addSubEntry(entry2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testIndexEntryMixedChildren() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        EIndexEntry entry3 = new EIndexEntry("ghi");
        entry2.addTopic(new ETopic("T1", false));
        entry3.addTopic(new ETopic("T2", true));
        entry1.addSubEntry(entry2);
        entry1.addSubEntry(entry3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)EnabledTopicUtils.isEnabled((IIndexEntry)entry1));
    }

    @Test
    public void testEnabledIndexArrayEmpty() {
        IIndexEntry[] entries = new EIndexEntry[]{};
        Object[] filtered = EnabledTopicUtils.getEnabled((IIndexEntry[])entries);
        Assertions.assertThat((Object[])filtered).isEmpty();
    }

    @Test
    public void testEnabledIndexArrayDisabled() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        IIndexEntry[] entries = new EIndexEntry[]{entry1, entry2};
        Object[] filtered = EnabledTopicUtils.getEnabled((IIndexEntry[])entries);
        Assertions.assertThat((Object[])filtered).isEmpty();
    }

    @Test
    public void testEnabledIndexArrayEnabled() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        entry1.addTopic(new ETopic("T1", true));
        entry2.addTopic(new ETopic("T2", true));
        IIndexEntry[] entries = new EIndexEntry[]{entry1, entry2};
        Object[] filtered = EnabledTopicUtils.getEnabled((IIndexEntry[])entries);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filtered).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getKeyword()).isEqualTo("abc");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getKeyword()).isEqualTo("def");
        }});
    }

    @Test
    public void testEnabledIndexArrayMixed() {
        EIndexEntry entry1 = new EIndexEntry("abc");
        EIndexEntry entry2 = new EIndexEntry("def");
        EIndexEntry entry3 = new EIndexEntry("ghi");
        EIndexEntry entry4 = new EIndexEntry("jkl");
        entry2.addTopic(new ETopic("T1", true));
        entry4.addTopic(new ETopic("T2", true));
        IIndexEntry[] entries = new EIndexEntry[]{entry1, entry2, entry3, entry4};
        Object[] filtered = EnabledTopicUtils.getEnabled((IIndexEntry[])entries);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])filtered).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{first -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)first.getKeyword()).isEqualTo("def");
        }, second -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)second.getKeyword()).isEqualTo("jkl");
        }});
    }

    private static class EIndexEntry
    extends UAElement
    implements IIndexEntry {
        private final String keyword;
        private final List<ITopic> topics = new ArrayList<ITopic>();
        private final List<IIndexEntry> subEntries = new ArrayList<IIndexEntry>();

        public EIndexEntry(String keyword) {
            super(keyword);
            this.keyword = keyword;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public void addSubEntry(IIndexEntry entry) {
            this.subEntries.add(entry);
        }

        public void addTopic(ITopic topic) {
            this.topics.add(topic);
        }

        public IIndexEntry[] getSubentries() {
            return this.subEntries.toArray(new IIndexEntry[this.subEntries.size()]);
        }

        public ITopic[] getTopics() {
            return this.topics.toArray(new ITopic[this.topics.size()]);
        }

        public synchronized IUAElement[] getChildren() {
            ArrayList<Object> all = new ArrayList<Object>();
            all.addAll(this.subEntries);
            all.addAll(this.topics);
            return all.toArray(new IUAElement[all.size()]);
        }
    }

    private static class ETopic
    implements ITopic {
        private final String label;
        private final boolean isEnabled;
        private final List<ITopic> children = new ArrayList<ITopic>();

        public ETopic(String label, boolean isEnabled) {
            this.label = label;
            this.isEnabled = isEnabled;
        }

        public ITopic[] getSubtopics() {
            return this.children.toArray(new ITopic[this.children.size()]);
        }

        public IUAElement[] getChildren() {
            return this.getSubtopics();
        }

        public boolean isEnabled(IEvaluationContext context) {
            return this.isEnabled;
        }

        public String getHref() {
            return "http://www.eclipse.org";
        }

        public String getLabel() {
            return this.label;
        }

        public void addSubTopic(ITopic subTopic) {
            this.children.add(subTopic);
        }
    }

    private static class NoHrefTopic
    extends ETopic {
        public NoHrefTopic(String label) {
            super(label, true);
        }

        @Override
        public String getHref() {
            return null;
        }
    }
}

