/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.DocumentWriter;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocAssembler;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.ua.tests.util.XMLUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class TocAssemblerTest {
    @Test
    public void testAssemble() throws Exception {
        TocFileParser parser = new TocFileParser();
        String bsn = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        TocContribution b = parser.parse(new TocFile(bsn, "data/help/toc/assembler/b.xml", true, "en", null, null));
        TocContribution c = parser.parse(new TocFile(bsn, "data/help/toc/assembler/c.xml", true, "en", null, null));
        TocContribution result_b_c = parser.parse(new TocFile(bsn, "data/help/toc/assembler/result_b_c.xml", true, "en", null, null));
        TocAssembler assembler = new TocAssembler();
        List<Object> contributions = new ArrayList<TocContribution>(Arrays.asList(b, c));
        contributions = assembler.assemble(contributions);
        Assertions.assertEquals((int)1, (int)contributions.size());
        String expected = this.serialize(result_b_c);
        String actual = this.serialize((TocContribution)contributions.get(0));
        XMLUtil.assertXMLEquals("Assembled TOC did not match expected result", expected, actual);
        TocContribution a = parser.parse(new TocFile(bsn, "data/help/toc/assembler/a.xml", true, "en", null, null));
        b = parser.parse(new TocFile(bsn, "data/help/toc/assembler/b.xml", true, "en", null, null));
        c = parser.parse(new TocFile(bsn, "data/help/toc/assembler/c.xml", true, "en", null, null));
        TocContribution d = parser.parse(new TocFile(bsn, "data/help/toc/assembler/d.xml", false, "en", null, null));
        TocContribution result_a_b_c_d = parser.parse(new TocFile(bsn, "data/help/toc/assembler/result_a_b_c_d.xml", true, "en", null, null));
        contributions = new ArrayList<TocContribution>(Arrays.asList(a, b, c, d));
        contributions = assembler.assemble(contributions);
        Assertions.assertEquals((int)1, (int)contributions.size());
        expected = this.serialize(result_a_b_c_d);
        actual = this.serialize((TocContribution)contributions.get(0));
        XMLUtil.assertXMLEquals("Assembled TOC did not match expected result", expected, actual);
    }

    @Test
    public void testInvalidLinkTo() throws Exception {
        TocFileParser parser = new TocFileParser();
        String bsn = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        TocContribution linkTo1 = parser.parse(new TocFile(bsn, "data/help/toc/assembler/linkTo1.xml", true, "en", null, null));
        TocContribution linkTo2 = parser.parse(new TocFile(bsn, "data/help/toc/assembler/linkTo2.xml", true, "en", null, null));
        TocContribution linkTo3 = parser.parse(new TocFile(bsn, "data/help/toc/assembler/linkTo3.xml", true, "en", null, null));
        TocAssembler assembler = new TocAssembler();
        List<Object> contributions = new ArrayList<TocContribution>(Arrays.asList(linkTo1, linkTo2, linkTo3));
        contributions = assembler.assemble(contributions);
        Assertions.assertEquals((int)3, (int)contributions.size());
    }

    @Test
    public void testHrefMap() throws Exception {
        TocFileParser parser = new TocFileParser();
        String bsn = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        TocContribution b = parser.parse(new TocFile(bsn, "data/help/toc/assembler/b.xml", true, "en", null, null));
        TocContribution c = parser.parse(new TocFile(bsn, "data/help/toc/assembler/c.xml", true, "en", null, null));
        TocAssembler assembler = new TocAssembler();
        List<Object> contributions = new ArrayList<TocContribution>(Arrays.asList(b, c));
        contributions = assembler.assemble(contributions);
        IToc toc = ((TocContribution)contributions.get(0)).getToc();
        Assertions.assertNotNull((Object)toc.getTopic("/org.eclipse.ua.tests/B_topic3.html"));
        Assertions.assertNotNull((Object)toc.getTopic("/org.eclipse.ua.tests/C_topic.html"));
        Assertions.assertNull((Object)toc.getTopic("/org.eclipse.ua.tests/D_topic.html"));
    }

    private String serialize(TocContribution contribution) throws Exception {
        DocumentWriter writer = new DocumentWriter();
        return new String(writer.writeString((UAElement)((Toc)contribution.getToc()), true));
    }
}

