/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import org.eclipse.help.internal.webapp.data.IconFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TocIconPathTest {
    @Test
    public void testNullId() {
        Assertions.assertNull((Object)IconFinder.getIconAltFromId(null));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId(null, (int)IconFinder.TYPEICON_CLOSED));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId(null, (int)IconFinder.TYPEICON_OPEN));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId(null, (int)IconFinder.TYPEICON_LEAF));
    }

    @Test
    public void testBadId() {
        Assertions.assertNull((Object)IconFinder.getIconAltFromId((String)"nosuchid"));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId((String)"nosuchid", (int)IconFinder.TYPEICON_CLOSED));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId((String)"nosuchid", (int)IconFinder.TYPEICON_OPEN));
        Assertions.assertNull((Object)IconFinder.getImagePathFromId((String)"nosuchid", (int)IconFinder.TYPEICON_LEAF));
    }

    @Test
    public void testIconSet() {
        String closedPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.iconSet", (int)IconFinder.TYPEICON_CLOSED);
        String openPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.iconSet", (int)IconFinder.TYPEICON_OPEN);
        String leafPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.iconSet", (int)IconFinder.TYPEICON_LEAF);
        String altId = IconFinder.getIconAltFromId((String)"org.eclipse.ua.tests.iconSet");
        Assertions.assertEquals((Object)"altSample", (Object)altId);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample.gif", (Object)openPath);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample2.gif", (Object)closedPath);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample3.gif", (Object)leafPath);
    }

    @Test
    public void testSingleIcon() {
        String closedPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.openOnly", (int)IconFinder.TYPEICON_CLOSED);
        String openPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.openOnly", (int)IconFinder.TYPEICON_OPEN);
        String leafPath = IconFinder.getImagePathFromId((String)"org.eclipse.ua.tests.openOnly", (int)IconFinder.TYPEICON_LEAF);
        String altId = IconFinder.getIconAltFromId((String)"org.eclipse.ua.tests.openOnly");
        Assertions.assertNull((Object)altId);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample.gif", (Object)openPath);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample.gif", (Object)closedPath);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/icons/sample.gif", (Object)leafPath);
    }

    @Test
    public void testNullIconNotDefined() {
        Assertions.assertFalse((boolean)IconFinder.isIconDefined(null));
    }

    @Test
    public void testEmptyIconNotDefined() {
        Assertions.assertFalse((boolean)IconFinder.isIconDefined(null));
    }

    @Test
    public void testUnknownIconNotDefined() {
        Assertions.assertFalse((boolean)IconFinder.isIconDefined((String)"nosuchid"));
    }

    @Test
    public void testKnownIconDefined() {
        Assertions.assertTrue((boolean)IconFinder.isIconDefined((String)"org.eclipse.ua.tests.iconSet"));
    }

    @Test
    public void testOpenOnlyDefined() {
        Assertions.assertTrue((boolean)IconFinder.isIconDefined((String)"org.eclipse.ua.tests.openOnly"));
    }
}

