/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IToc;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.HelpData;
import org.eclipse.help.internal.toc.TocSorter;
import org.eclipse.help.internal.util.ProductPreferences;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TocSortingTest {
    private static final String BASE_TOCS = "baseTOCS";
    private static final String ORDERED_XML = "PLUGINS_ROOT/org.eclipse.ua.tests/data/help/toc/toc_data/helpDataOrdered.xml";
    private static final String EMPTY_XML = "PLUGINS_ROOT/org.eclipse.ua.tests/data/help/toc/toc_data/helpDataEmpty.xml";
    private static final String NO_SORT_XML = "PLUGINS_ROOT/org.eclipse.ua.tests/data/help/toc/toc_data/helpDataOrderedNoSort.xml";
    private static final String BAD_PLUGIN_HELP_DATA_XML = "PLUGINS_ROOT/org.eclipse.nosuchplugin/data/help/toc/toc_data/helpData.xml";
    private static final String NO_SUCH_FILE_XML = "PLUGINS_ROOT/org.eclipse.ua.tests/data/help/toc/toc_data/noSuchFile.xml";
    private static final String ALPHA_SORT_XML = "PLUGINS_ROOT/org.eclipse.ua.tests/data/help/toc/toc_data/helpDataOrderedAlphaSort.xml";
    private String helpDataPreference;
    private String baseTocsPreference;

    @BeforeEach
    public void setUp() throws Exception {
        this.helpDataPreference = Platform.getPreferencesService().getString("HELP_DATA", "HELP_DATA", "", null);
        this.baseTocsPreference = Platform.getPreferencesService().getString("HELP_DATA", BASE_TOCS, "", null);
        HelpData.clearProductHelpData();
        ProductPreferences.resetPrimaryTocOrdering();
        this.setHelpData(EMPTY_XML);
        this.setBaseTocs("");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.setHelpData(this.helpDataPreference);
        this.setBaseTocs(this.baseTocsPreference);
        HelpData.clearProductHelpData();
        ProductPreferences.resetPrimaryTocOrdering();
    }

    private void setHelpData(String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help");
        prefs.put("HELP_DATA", value);
    }

    private void setBaseTocs(String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help");
        prefs.put(BASE_TOCS, value);
    }

    private String toString(ITocContribution[] tocs) {
        Object result = "";
        ITocContribution[] iTocContributionArray = tocs;
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            ITocContribution toc = iTocContributionArray[n2];
            result = (String)result + toc.getToc().getLabel();
            ++n2;
        }
        return result;
    }

    @Test
    public void testNoTocs() {
        TocSorter sorter = new TocSorter();
        Object[] result = sorter.orderTocContributions((ITocContribution[])new TC[0]);
        Assertions.assertThat((Object[])result).isEmpty();
    }

    @Test
    public void testNoCategory() {
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("5", null), new TC("3", null), new TC("8", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"358", (Object)this.toString(result));
    }

    @Test
    public void testCaseInsensitive() {
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("a", null), new TC("c", null), new TC("B", null), new TC("D", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"aBcD", (Object)this.toString(result));
    }

    @Test
    public void testCategories() {
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("4", null), new TC("2", "a"), new TC("5", "b"), new TC("1", null), new TC("8", ""), new TC("7", "a"), new TC("9", "b"), new TC("3", ""), new TC("6", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"127345968", (Object)this.toString(result));
    }

    @Test
    public void testTocOrderPreference() {
        this.setHelpData(ORDERED_XML);
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("a", null), new TC("c", null), new TC("b", null), new TC("d", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbac", (Object)this.toString(result));
    }

    @Test
    public void testTocNoSortOthers() {
        this.setHelpData(NO_SORT_XML);
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbeca", (Object)this.toString(result));
    }

    @Test
    public void testTocAlphaSortOthers() {
        this.setHelpData(ALPHA_SORT_XML);
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbace", (Object)this.toString(result));
    }

    @Test
    public void testTocBadHelpDataPlugin() {
        this.setHelpData(BAD_PLUGIN_HELP_DATA_XML);
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcde", (Object)this.toString(result));
    }

    @Test
    public void testTocBadHelpDataPath() {
        this.setHelpData(NO_SUCH_FILE_XML);
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcde", (Object)this.toString(result));
    }

    @Test
    public void testNoHelpData() {
        this.setHelpData("");
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcde", (Object)this.toString(result));
    }

    @Test
    public void testBaseTocs() {
        this.setHelpData("");
        this.setBaseTocs("/d/toc.xml,/b/toc.xml");
        TocSorter sorter = new TocSorter();
        ITocContribution[] tocs = new ITocContribution[]{new TC("e", null), new TC("c", null), new TC("b", null), new TC("d", null), new TC("a", null)};
        ITocContribution[] result = sorter.orderTocContributions(tocs);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"dbace", (Object)this.toString(result));
    }

    @Test
    public void testNoProductNoHelpData() {
        List ordering = ProductPreferences.getTocOrdering(null, (String)"", (String)"/a/b.xml,/c/d.xml");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)ordering.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/a/b.xml", ordering.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/c/d.xml", ordering.get(1));
    }

    @Test
    public void testNoProductWithHelpData() {
        List ordering = ProductPreferences.getTocOrdering(null, (String)"helpData.xml", (String)"/a/b.xml,/c/d.xml");
        org.junit.jupiter.api.Assertions.assertNull((Object)ordering);
    }

    @Test
    public void testNoProductWithPluginsRoot() {
        List ordering = ProductPreferences.getTocOrdering(null, (String)ORDERED_XML, (String)"/a/b.xml,/c/d.xml");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)ordering.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/x/toc.xml", ordering.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/d/toc.xml", ordering.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/b/toc.xml", ordering.get(2));
    }

    private static class TC
    implements ITocContribution {
        private final IToc toc;
        private final String categoryId;
        private final String id;

        public TC(String name, String category) {
            this.categoryId = category;
            this.id = "/" + name + "/toc.xml";
            this.toc = new Toc(name);
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getContributorId() {
            return "org.eclipse.ua.tests";
        }

        public String[] getExtraDocuments() {
            return new String[0];
        }

        public String getId() {
            return this.id;
        }

        public String getLinkTo() {
            return null;
        }

        public String getLocale() {
            return "en";
        }

        public IToc getToc() {
            return this.toc;
        }

        public boolean isPrimary() {
            return true;
        }
    }

    private static class Toc
    implements IToc {
        private final String label;

        public Toc(String label) {
            this.label = label;
        }

        public ITopic getTopic(String href) {
            return null;
        }

        public ITopic[] getTopics() {
            return new ITopic[0];
        }

        public IUAElement[] getChildren() {
            return new IUAElement[0];
        }

        public boolean isEnabled(IEvaluationContext context) {
            return true;
        }

        public String getHref() {
            return null;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

