/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import org.assertj.core.api.Assertions;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.FilterScope;
import org.eclipse.help.internal.base.scope.UniversalScope;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.TopicFinder;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.junit.jupiter.api.Test;

public class TopicFinderTest {
    private IToc[] getTocs() {
        return HelpPlugin.getTocManager().getTocs("en");
    }

    @Test
    public void testTocsFound() {
        Assertions.assertThat((Object[])this.getTocs()).isNotEmpty();
    }

    @Test
    public void testNoTocs() {
        TopicFinder finder = new TopicFinder("http:", new IToc[0], (AbstractHelpScope)new UniversalScope());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)finder.getSelectedToc());
        org.junit.jupiter.api.Assertions.assertNull((Object)finder.getTopicPath());
    }

    @Test
    public void testNoTopic() {
        TopicFinder finder = new TopicFinder(null, this.getTocs(), (AbstractHelpScope)new UniversalScope());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)finder.getSelectedToc());
        org.junit.jupiter.api.Assertions.assertNull((Object)finder.getTopicPath());
    }

    @Test
    public void testTopicInToc() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/manual/filter.xhtml";
        TopicFinder finder = new TopicFinder(topic, this.getTocs(), (AbstractHelpScope)new UniversalScope());
        int selectedToc = finder.getSelectedToc();
        org.junit.jupiter.api.Assertions.assertFalse((selectedToc == -1 ? 1 : 0) != 0);
        Object[] path = finder.getTopicPath();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)path);
        String tocHref = this.getTocs()[selectedToc].getHref();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/toc/root.xml", (Object)tocHref);
        Assertions.assertThat((Object[])path).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"manual", (Object)path[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"filter", (Object)path[1].getLabel());
    }

    @Test
    public void testTopicInTocWithAnchor() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/manual/filter.xhtml#ABC";
        TopicFinder finder = new TopicFinder(topic, this.getTocs(), (AbstractHelpScope)new UniversalScope());
        int selectedToc = finder.getSelectedToc();
        org.junit.jupiter.api.Assertions.assertFalse((selectedToc == -1 ? 1 : 0) != 0);
        Object[] path = finder.getTopicPath();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)path);
        String tocHref = this.getTocs()[selectedToc].getHref();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/toc/root.xml", (Object)tocHref);
        Assertions.assertThat((Object[])path).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"manual", (Object)path[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"filter", (Object)path[1].getLabel());
    }

    @Test
    public void testTopicInFilteredToc() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html";
        TopicFinder finder = new TopicFinder(topic, this.getTocs(), (AbstractHelpScope)new FilterScope());
        int selectedToc = finder.getSelectedToc();
        org.junit.jupiter.api.Assertions.assertFalse((selectedToc == -1 ? 1 : 0) != 0);
        Object[] path = finder.getTopicPath();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)path);
        String tocHref = this.getTocs()[selectedToc].getHref();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/toc/root.xml", (Object)tocHref);
        Assertions.assertThat((Object[])path).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"filter", (Object)path[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The plugin org.eclipse.help is installed", (Object)path[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html", (Object)path[1].getHref());
    }

    @Test
    public void testTopicNotInToc() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/manual/filter25.xhtml";
        TopicFinder finder = new TopicFinder(topic, this.getTocs(), (AbstractHelpScope)new UniversalScope());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)finder.getSelectedToc());
        org.junit.jupiter.api.Assertions.assertNull((Object)finder.getTopicPath());
    }

    @Test
    public void testLookupFromPath() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html";
        IToc[] tocs = this.getTocs();
        TopicFinder finder = new TopicFinder(topic, tocs, (AbstractHelpScope)new FilterScope());
        String numericPath = finder.getNumericPath();
        int tocIndex = finder.getSelectedToc();
        String fullPath = tocIndex + "_" + numericPath;
        int[] intPath = UrlUtil.splitPath((String)fullPath);
        Object[] topics = TocData.decodePath((int[])intPath, (IToc)tocs[tocIndex], (AbstractHelpScope)new FilterScope());
        Assertions.assertThat((Object[])topics).hasSize(2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"filter", (Object)topics[0].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The plugin org.eclipse.help is installed", (Object)topics[1].getLabel());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html", (Object)topics[1].getHref());
    }

    @Test
    public void testTocNavURL() {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html";
        IToc[] tocs = this.getTocs();
        TopicFinder finder = new TopicFinder(topic, tocs, (AbstractHelpScope)new UniversalScope());
        int selectedToc = finder.getSelectedToc();
        String navPath = "http://127.0.0.1:1936/help/nav/" + selectedToc;
        TopicFinder finder2 = new TopicFinder(navPath, tocs, (AbstractHelpScope)new UniversalScope());
        org.junit.jupiter.api.Assertions.assertEquals((int)selectedToc, (int)finder2.getSelectedToc());
        Assertions.assertThat((Object[])finder2.getTopicPath()).isEmpty();
    }

    @Test
    public void testTopic_0_0NavURL() {
        this.checkNavTopic(0, 0);
    }

    @Test
    public void testTopic_0_1NavURL() {
        this.checkNavTopic(0, 1);
    }

    @Test
    public void testTopic_1_0NavURL() {
        this.checkNavTopic(1, 0);
    }

    private void checkNavTopic(int index1, int index2) {
        String topic = "http://localhost:8082/help/topic/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html";
        IToc[] tocs = this.getTocs();
        TopicFinder finder = new TopicFinder(topic, tocs, (AbstractHelpScope)new UniversalScope());
        int selectedToc = finder.getSelectedToc();
        String navPath = "http://127.0.0.1:1936/help/nav/" + selectedToc + "_" + index1 + "_" + index2;
        TopicFinder finder2 = new TopicFinder(navPath, tocs, (AbstractHelpScope)new UniversalScope());
        org.junit.jupiter.api.Assertions.assertEquals((int)selectedToc, (int)finder2.getSelectedToc());
        Object[] topicPath = finder2.getTopicPath();
        Assertions.assertThat((Object[])topicPath).hasSize(2);
        ITopic[] topLevelTopics = tocs[selectedToc].getTopics();
        org.junit.jupiter.api.Assertions.assertEquals((Object)topLevelTopics[index1], (Object)topicPath[0]);
        ITopic[] secondLevelTopics = topLevelTopics[index1].getSubtopics();
        org.junit.jupiter.api.Assertions.assertEquals((Object)secondLevelTopics[index2], (Object)topicPath[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(index1 + "_" + index2), (Object)finder2.getNumericPath());
    }
}

