/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.toc;

import org.eclipse.help.ITopic;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.help.internal.toc.TopicSorter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class TopicSortingTest {
    @Test
    public void testSortTocChildren() throws Exception {
        TocFileParser parser = new TocFileParser();
        TocContribution contribution = parser.parse(new TocFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/toc/assembler/sorted.xml", true, "en", null, null));
        TopicSorter sorter = new TopicSorter();
        Toc toc = (Toc)contribution.getToc();
        sorter.sortChildren(toc);
        ITopic[] children = toc.getTopics();
        Assertions.assertEquals((Object)"A Topic (sorted)", (Object)children[0].getLabel());
        Assertions.assertEquals((Object)"B Topic", (Object)children[1].getLabel());
        Assertions.assertEquals((Object)"C Topic", (Object)children[2].getLabel());
    }

    @Test
    public void testSortNestedTopics() throws Exception {
        TocFileParser parser = new TocFileParser();
        TocContribution contribution = parser.parse(new TocFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/toc/assembler/sorted.xml", true, "en", null, null));
        TopicSorter sorter = new TopicSorter();
        Toc toc = (Toc)contribution.getToc();
        sorter.sortChildren(toc);
        ITopic[] children = toc.getTopics();
        ITopic topicA = children[0];
        Assertions.assertEquals((Object)"A Topic (sorted)", (Object)topicA.getLabel());
        ITopic[] childrenOfA = topicA.getSubtopics();
        Assertions.assertEquals((Object)"A Child", (Object)childrenOfA[0].getLabel());
        Assertions.assertEquals((Object)"B Child", (Object)childrenOfA[1].getLabel());
    }

    @Test
    public void testUnsortedNestedTopics() throws Exception {
        TocFileParser parser = new TocFileParser();
        TocContribution contribution = parser.parse(new TocFile(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "data/help/toc/assembler/sorted.xml", true, "en", null, null));
        TopicSorter sorter = new TopicSorter();
        Toc toc = (Toc)contribution.getToc();
        sorter.sortChildren(toc);
        ITopic[] children = toc.getTopics();
        ITopic topicC = children[2];
        Assertions.assertEquals((Object)"C Topic", (Object)topicC.getLabel());
        ITopic[] childrenOfC = topicC.getSubtopics();
        Assertions.assertEquals((Object)"B Child of C", (Object)childrenOfC[0].getLabel());
        Assertions.assertEquals((Object)"A Child of C", (Object)childrenOfC[1].getLabel());
    }
}

