/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.internal.server.WebappManager;

public class LoadServletUtil {
    private static long uniqueParam = System.currentTimeMillis();

    public static void startServer() throws Exception {
        WebappManager.start((String)"help");
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/index.jsp");
        URLConnection connection = url.openConnection();
        LoadServletUtil.setTimeout(connection, 5000);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = url.openStream();){
            int firstbyte = input.read();
            Assertions.assertThat((int)firstbyte).isGreaterThan(0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void stopServer() throws CoreException {
        WebappManager.stop((String)"help");
    }

    public static void readLoadServlet(int paragraphs) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/loadtest?value=" + ++uniqueParam + "&repeat=" + paragraphs);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = url.openStream();){
            int nextChar;
            long value = 0L;
            boolean inFirstComment = true;
            do {
                nextChar = input.read();
                if (!inFirstComment) continue;
                if (nextChar == 62) {
                    inFirstComment = false;
                    continue;
                }
                if (!Character.isDigit((char)nextChar)) continue;
                value = value * 10L + (long)(nextChar - 48);
            } while (nextChar != 36);
            org.junit.jupiter.api.Assertions.assertEquals((long)uniqueParam, (long)value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void setTimeout(URLConnection conn, int milliseconds) {
        conn.setConnectTimeout(milliseconds);
        conn.setReadTimeout(milliseconds);
    }
}

