/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.util;

import org.junit.jupiter.api.Assertions;

public class ParallelTestSupport {
    public static void testSingleCase(ITestCase testCase, int repetitions) {
        String result = null;
        int i = 0;
        while (i < repetitions && result == null) {
            try {
                result = testCase.runTest();
            }
            catch (Exception e) {
                result = e.getMessage();
            }
            if (result != null) {
                Assertions.fail((String)result);
            }
            ++i;
        }
    }

    public static void testInParallel(ITestCase[] testCases, int repetitions) {
        int i;
        int numberOfThreads = testCases.length;
        TestThread[] testThreads = new TestThread[numberOfThreads];
        int i2 = 0;
        while (i2 < numberOfThreads) {
            testThreads[i2] = new TestThread(i2, testCases[i2], repetitions);
            testThreads[i2].start();
            ++i2;
        }
        boolean complete = false;
        do {
            complete = true;
            i = 0;
            while (i < numberOfThreads && complete) {
                if (testThreads[i].isAlive()) {
                    complete = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Interrupted Exception");
                    }
                }
                ++i;
            }
        } while (!complete);
        i = 0;
        while (i < numberOfThreads) {
            if (testThreads[i].failureReason != null) {
                Assertions.fail((String)testThreads[i].failureReason);
            }
            ++i;
        }
    }

    public static interface ITestCase {
        public String runTest() throws Exception;
    }

    private static class TestThread
    extends Thread {
        private final int index;
        private final ITestCase testCase;
        private final int repetitions;
        public String failureReason = null;

        public TestThread(int index, ITestCase testCase, int repetitions) {
            this.index = index;
            this.testCase = testCase;
            this.repetitions = repetitions;
        }

        @Override
        public void run() {
            int j = 0;
            while (j <= this.repetitions) {
                try {
                    String unexpected = this.testCase.runTest();
                    if (unexpected != null) {
                        this.failureReason = "Thread " + this.index + ", iteration " + j + ": " + unexpected;
                        return;
                    }
                }
                catch (Exception e) {
                    this.failureReason = e.getMessage();
                    return;
                }
                ++j;
            }
        }
    }
}

