/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.util;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.HelpEvaluationContext;

public class TocModelSerializer {
    private static final String EMPTY_STRING = "";

    public static String serialize(IToc toc) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        buf.append(TocModelSerializer.serializeAux(toc, EMPTY_STRING));
        return buf.toString();
    }

    private static String serializeAux(IToc toc, String indent) {
        if (!UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext())) {
            ITopic[] topics;
            StringBuilder buf = new StringBuilder();
            buf.append(indent + "<toc\n");
            buf.append(indent + "      label=\"" + toc.getLabel() + "\"\n");
            buf.append(indent + "      href=\"" + toc.getHref() + "\">\n");
            ITopic[] iTopicArray = topics = toc.getTopics();
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                buf.append(TocModelSerializer.serializeAux(topic, indent + "   "));
                ++n2;
            }
            buf.append(indent + "</toc>");
            return buf.toString();
        }
        return EMPTY_STRING;
    }

    private static String serializeAux(ITopic topic, String indent) {
        if (!UAContentFilter.isFiltered((Object)topic, (IEvaluationContext)HelpEvaluationContext.getContext())) {
            ITopic[] subtopics;
            StringBuilder buf = new StringBuilder();
            buf.append(indent + "<topic\n");
            buf.append(indent + "      label=\"" + topic.getLabel() + "\"\n");
            buf.append(indent + "      href=\"" + topic.getHref() + "\">\n");
            ITopic[] iTopicArray = subtopics = topic.getSubtopics();
            int n = subtopics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic subtopic = iTopicArray[n2];
                buf.append(TocModelSerializer.serializeAux(subtopic, indent + "   "));
                ++n2;
            }
            buf.append(indent + "</topic>\n");
            return buf.toString();
        }
        return EMPTY_STRING;
    }
}

