/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrowserIdentificationTest {
    @Test
    public void testIE_6() {
        String agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
        Assertions.assertTrue((boolean)UrlUtil.isIE((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"));
        Assertions.assertFalse((boolean)UrlUtil.isMozilla((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"));
        Assertions.assertEquals((Object)"6.0", (Object)UrlUtil.getIEVersion((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)"));
    }

    @Test
    public void testWindowsFirefox_1_8() {
        String agent = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8"));
        Assertions.assertEquals((Object)"1.8.0.8", (Object)UrlUtil.getMozillaVersion((String)"Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.8) Gecko/20061025 (CK-IBM) Firefox/1.5.0.8"));
    }

    @Test
    public void testGTKFirefox_1_4() {
        String agent = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922"));
        Assertions.assertEquals((Object)"1.4", (Object)UrlUtil.getMozillaVersion((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) Gecko/20030922"));
    }

    @Test
    public void testGTKKonqueror_3_1() {
        String agent = "Mozilla/5.0 (compatible; Konqueror/3.1; Linux)";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (compatible; Konqueror/3.1; Linux)"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (compatible; Konqueror/3.1; Linux)"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (compatible; Konqueror/3.1; Linux)"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (compatible; Konqueror/3.1; Linux)"));
    }

    @Test
    public void testMacMozilla1_7_3() {
        String agent = "Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910"));
        Assertions.assertEquals((Object)"1.7.3", (Object)UrlUtil.getMozillaVersion((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7.3) Gecko/20040910"));
    }

    @Test
    public void testSafari_417_8() {
        String agent = "Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8"));
        Assertions.assertTrue((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8"));
        Assertions.assertEquals((Object)"417", (Object)UrlUtil.getSafariVersion((String)"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; en) AppleWebKit/417.9 (KHTML, like Gecko) Safari/417.8"));
    }

    @Test
    public void testOpera_9() {
        String agent = "Opera/9.02 (Windows NT 5.1; U; en)";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Opera/9.02 (Windows NT 5.1; U; en)"));
        Assertions.assertFalse((boolean)UrlUtil.isMozilla((String)"Opera/9.02 (Windows NT 5.1; U; en)"));
        Assertions.assertTrue((boolean)UrlUtil.isOpera((String)"Opera/9.02 (Windows NT 5.1; U; en)"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Opera/9.02 (Windows NT 5.1; U; en)"));
        Assertions.assertEquals((Object)"9.02", (Object)UrlUtil.getOperaVersion((String)"Opera/9.02 (Windows NT 5.1; U; en)"));
    }

    @Test
    public void testOpera_9_IEMode() {
        String agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02";
        Assertions.assertTrue((boolean)UrlUtil.isIE((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02"));
        Assertions.assertFalse((boolean)UrlUtil.isMozilla((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02"));
        Assertions.assertTrue((boolean)UrlUtil.isOpera((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02"));
        Assertions.assertEquals((Object)"6.0", (Object)UrlUtil.getIEVersion((String)"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; en) Opera 9.02"));
    }

    @Test
    public void testXulRunnerOnUbuntu() {
        String agent = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko"));
        Assertions.assertEquals((Object)"1.9", (Object)UrlUtil.getMozillaVersion((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9) Gecko"));
    }

    @Test
    public void testXulRunnerTruncated() {
        String agent = "Mozilla/5.0 (X11; U; Linux i686;";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (X11; U; Linux i686;"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (X11; U; Linux i686;"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (X11; U; Linux i686;"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (X11; U; Linux i686;"));
    }

    @Test
    public void testFirefox3() {
        String agent = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031";
        Assertions.assertFalse((boolean)UrlUtil.isIE((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031"));
        Assertions.assertTrue((boolean)UrlUtil.isMozilla((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031"));
        Assertions.assertFalse((boolean)UrlUtil.isOpera((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031"));
        Assertions.assertFalse((boolean)UrlUtil.isSafari((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031"));
        Assertions.assertEquals((Object)"1.8.1.13", (Object)UrlUtil.getMozillaVersion((String)"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.13) Gecko/2008031"));
    }
}

