/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.servlet.PluginsRootResolvingStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChildLinkInsertion {
    @Test
    public void testEmpty() {
        String input = "";
        this.checkFilter("", "");
    }

    @Test
    public void testNoMatch() {
        String input = "<HEAD><HEAD/>";
        this.checkFilter("<HEAD><HEAD/>", "<HEAD><HEAD/>");
    }

    @Test
    public void testPartialMatch1() {
        String input = "<A href = \"PLUGINS\"><!--INSTRUCT-->";
        this.checkFilter("<A href = \"PLUGINS\"><!--INSTRUCT-->", "<A href = \"PLUGINS\"><!--INSTRUCT-->");
    }

    @Test
    public void testPartialMatch2() {
        String input = "<A href = \"PLUGINS\"><!A -->";
        this.checkFilter("<A href = \"PLUGINS\"><!A -->", "<A href = \"PLUGINS\"><!A -->");
    }

    @Test
    public void testPartialMatch3() {
        String input = "<A href = \"PLUGINS\"><!-A -->";
        this.checkFilter("<A href = \"PLUGINS\"><!-A -->", "<A href = \"PLUGINS\"><!-A -->");
    }

    @Test
    public void testPartialMatch4() {
        String input = "<A href = \"PLUGINS\"><!--A-->";
        this.checkFilter("<A href = \"PLUGINS\"><!--A-->", "<A href = \"PLUGINS\"><!--A-->");
    }

    @Test
    public void testEndsUnmatched() {
        String input = "<A><!--INSTR";
        this.checkFilter("<A><!--INSTR", "<A><!--INSTR");
    }

    @Test
    public void testNotAtStart() {
        String input = "<A><!-- INSERT_CHILD_LINKS-->";
        this.checkFilter("<A><!-- INSERT_CHILD_LINKS-->", "<A><!-- INSERT_CHILD_LINKS-->");
    }

    @Test
    public void testSpaceBeforeEnd() {
        String input = "<A><!-- INSERT_CHILD_LINKS -->";
        this.checkFilter("<A><!-- INSERT_CHILD_LINKS -->", "<A><!-- INSERT_CHILD_LINKS -->");
    }

    @Test
    public void testTooManyCharacters_1() {
        String input = "<A><!--INSERT_CHILD_LINKSS-->";
        this.checkFilter("<A><!--INSERT_CHILD_LINKSS-->", "<A><!--INSERT_CHILD_LINKSS-->");
    }

    @Test
    public void testTooManyCharacters_2() {
        String input = "<A><!--INSERT_CHILD_LINKS_STYLES-->";
        this.checkFilter("<A><!--INSERT_CHILD_LINKS_STYLES-->", "<A><!--INSERT_CHILD_LINKS_STYLES-->");
    }

    @Test
    public void testAtStart() {
        String input = "<!--INSERT_CHILD_LINKS--><A>";
        String expected = "<LINKS><A>";
        this.checkFilter("<!--INSERT_CHILD_LINKS--><A>", "<LINKS><A>");
    }

    @Test
    public void testChildStyle() {
        String input = "<!--INSERT_CHILD_LINK_STYLE--><A>";
        String expected = "<STYLE><A>";
        this.checkFilter("<!--INSERT_CHILD_LINK_STYLE--><A>", "<STYLE><A>");
    }

    @Test
    public void testDefaultEncoding() {
        String input = "";
        this.checkEncoding("", null);
    }

    @Test
    public void testEncodingUtf8() {
        String input = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
        this.checkEncoding("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">", "utf-8");
    }

    @Test
    public void testMetaNoEncoding() {
        String input = "<meta http-equiv=\"Content-Type\" content=\"text/html\">";
        this.checkEncoding("<meta http-equiv=\"Content-Type\" content=\"text/html\">", null);
    }

    @Test
    public void testMultiMeta() {
        String input = "<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><meta name=\"test\" content=\"test\">";
        this.checkEncoding("<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><meta name=\"test\" content=\"test\">", "utf-8");
    }

    @Test
    public void testMetaAndInsert() {
        String metaInfo = "<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
        String input = "<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><!--INSERT_CHILD_LINK_STYLE--><A>";
        String expected = "<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><STYLE><A>";
        this.checkFilter("<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><!--INSERT_CHILD_LINK_STYLE--><A>", "<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><STYLE><A>");
        this.checkEncoding("<meta name=\"test\" content=\"test\"><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><!--INSERT_CHILD_LINK_STYLE--><A>", "utf-8");
    }

    private void checkFilter(String input, String expected) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TestableReplacementStream filteredOutput = new TestableReplacementStream(output, null, "../");){
                ((OutputStream)((Object)filteredOutput)).write(input.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        Assertions.assertEquals((Object)expected, (Object)output.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEncoding(String input, String expectedEncoding) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    try (TestableReplacementStream filteredOutput = new TestableReplacementStream(output, null, "../");){
                        filteredOutput.write(input.getBytes());
                        if (expectedEncoding == null) {
                            Assertions.assertNull((Object)filteredOutput.getCharset());
                        } else {
                            Assertions.assertEquals((Object)expectedEncoding, (Object)filteredOutput.getCharset());
                        }
                    }
                    if (output == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                output.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
    }

    private class TestableReplacementStream
    extends PluginsRootResolvingStream {
        public TestableReplacementStream(OutputStream out, HttpServletRequest req, String prefix) {
            super(out, req, prefix);
        }

        protected void insertBasedOnKeyword(int index) throws IOException {
            if (index == 0) {
                this.out.write("<LINKS>".getBytes());
            } else if (index == 1) {
                this.out.write("<STYLE>".getBytes());
            } else {
                this.out.write("<UNKNOWN>".getBytes());
            }
        }
    }
}

