/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.webapp.IFilter;

public class CommentFilter
implements IFilter {
    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        return new OutFilter(out);
    }

    protected String getCommentText() {
        return "comment";
    }

    private class OutFilter
    extends OutputStream {
        private final OutputStream out;
        private boolean preambleWritten = false;

        public OutFilter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.preambleWritten) {
                this.preambleWritten = true;
                String comment = "<!-- pre " + CommentFilter.this.getCommentText() + " -->";
                this.out.write(comment.getBytes());
            }
            this.out.write(b);
        }

        @Override
        public void close() throws IOException {
            String comment = "<!-- post " + CommentFilter.this.getCommentText() + " -->";
            this.out.write(comment.getBytes());
            this.out.close();
            super.close();
        }
    }
}

