/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.net.URL;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.remote.RemotePreferenceStore;
import org.eclipse.ua.tests.help.remote.RemoteTestUtils;
import org.eclipse.ua.tests.help.remote.TestServerManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EclipseConnectorTests {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        RemotePreferenceStore.savePreferences();
        RemotePreferenceStore.setMockRemoteServer();
        BaseHelpSystem.setMode((int)1);
        HelpPlugin.getTocManager().getTocs("en");
    }

    @AfterEach
    public void tearDown() throws Exception {
        RemotePreferenceStore.restorePreferences();
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testEncodedAmpersand() throws Exception {
        String path = "/data/help/index/topic&.html";
        String requestPath = URIUtil.fromString((String)"/data/help/index/topic&.html").toString();
        String remoteContent = EclipseConnectorTests.getHelpContent("mock.toc", requestPath, "en");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent("mock.toc", "/data/help/index/topic&.html", "en", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    @Test
    public void testEncodedSpace() throws Exception {
        String path = "/data/help/index/topic .html";
        String requestPath = URIUtil.fromString((String)"/data/help/index/topic .html").toString();
        String remoteContent = EclipseConnectorTests.getHelpContent("mock.toc", requestPath, "en");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent("mock.toc", "/data/help/index/topic .html", "en", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    @Test
    public void testEncodedPercentSign() throws Exception {
        String path = "/data/help/index/topic%.html";
        String requestPath = URIUtil.fromString((String)"/data/help/index/topic%.html").toString();
        String remoteContent = EclipseConnectorTests.getHelpContent("mock.toc", requestPath, "en");
        int port = TestServerManager.getPort(0);
        String expectedContent = RemoteTestUtils.createMockContent("mock.toc", "/data/help/index/topic%.html", "en", port);
        Assertions.assertEquals((Object)expectedContent, (Object)remoteContent);
    }

    private static String getHelpContent(String plugin, String path, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/nftopic/" + plugin + path + "?lang=" + locale);
        return RemoteTestUtils.readFromURL(url);
    }
}

