/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.servlet.ExtraFilters;
import org.eclipse.help.internal.webapp.servlet.PrioritizedFilter;
import org.eclipse.help.webapp.IFilter;
import org.eclipse.ua.tests.help.webapp.CommentFilterOne;
import org.eclipse.ua.tests.help.webapp.CommentFilterThree;
import org.eclipse.ua.tests.help.webapp.CommentFilterTwo;
import org.eclipse.ua.tests.help.webapp.MockServletRequest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterExtensionTest {
    @AfterEach
    public void tearDown() throws Exception {
        ExtraFilters.setFilters((PrioritizedFilter[])new PrioritizedFilter[0]);
    }

    @Test
    public void testFilterExtensions() throws IOException {
        PrioritizedFilter[] filters = new PrioritizedFilter[]{new PrioritizedFilter((IFilter)new CommentFilterTwo(), 2), new PrioritizedFilter((IFilter)new CommentFilterThree(), 3), new PrioritizedFilter((IFilter)new CommentFilterOne(), 1)};
        ExtraFilters.setFilters((PrioritizedFilter[])filters);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        MockServletRequest req = new MockServletRequest();
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream filteredOutput = new ExtraFilters().filter((HttpServletRequest)req, (OutputStream)out);){
            filteredOutput.write("<html>".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String result = ((Object)out).toString();
        String expected = "<!-- pre 3 --><!-- pre 2 --><!-- pre 1 --><html><!-- post 1 --><!-- post 2 --><!-- post 3 -->";
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRepeatedExtensions() throws IOException {
        PrioritizedFilter[] filters = new PrioritizedFilter[]{new PrioritizedFilter((IFilter)new CommentFilterTwo(), 2), new PrioritizedFilter((IFilter)new CommentFilterThree(), 3), new PrioritizedFilter((IFilter)new CommentFilterTwo(), 1)};
        ExtraFilters.setFilters((PrioritizedFilter[])filters);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        MockServletRequest req = new MockServletRequest();
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream filteredOutput = new ExtraFilters().filter((HttpServletRequest)req, (OutputStream)out);){
            filteredOutput.write("<html>".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String result = ((Object)out).toString();
        String expected = "<!-- pre 3 --><!-- pre 2 --><!-- pre 2 --><html><!-- post 2 --><!-- post 2 --><!-- post 3 -->";
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testNoFilters() throws IOException {
        PrioritizedFilter[] filters = new PrioritizedFilter[]{};
        ExtraFilters.setFilters((PrioritizedFilter[])filters);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        MockServletRequest req = new MockServletRequest();
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream filteredOutput = new ExtraFilters().filter((HttpServletRequest)req, (OutputStream)out);){
            filteredOutput.write("<html>".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String result = ((Object)out).toString();
        String expected = "<html>";
        Assertions.assertEquals((Object)expected, (Object)result);
    }
}

